/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class AnonymousTypeCompletionProposal {
    private ICompilationUnit fCompilationUnit;
    private int fReplacementOffset;
    private IType fSuperType;
    private IJavaProject fJavaProject;
    private String fDeclarationSignature;
    private boolean fSnippetSupport;

    public AnonymousTypeCompletionProposal(ICompilationUnit cu, int replacementOffset, IType superType, String declarationSignature, boolean snippetSupport) {
        Assert.isNotNull((Object)cu.getJavaProject());
        Assert.isNotNull((Object)superType);
        Assert.isNotNull((Object)cu);
        Assert.isNotNull((Object)declarationSignature);
        this.fCompilationUnit = cu;
        this.fReplacementOffset = replacementOffset;
        this.fJavaProject = cu.getJavaProject();
        this.fDeclarationSignature = declarationSignature;
        this.fSuperType = superType;
        this.fSnippetSupport = snippetSupport;
    }

    public String updateReplacementString(IDocument document, int offset, ImportRewrite impRewrite) throws CoreException, BadLocationException {
        String newBody = this.fSnippetSupport ? "{\n\t${0}\n}" : "{\n\n}";
        StringBuilder buf = new StringBuilder("new A()");
        buf.append(newBody);
        String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        IRegion lineInfo = document.getLineInformationOfOffset(this.fReplacementOffset);
        Hashtable options = project != null ? project.getOptions(true) : JavaCore.getOptions();
        String replacementString = CodeFormatterUtil.format((int)1, (String)buf.toString(), (int)0, (String)lineDelim, (Map)options);
        int lineEndOffset = lineInfo.getOffset() + lineInfo.getLength();
        int p = offset;
        if (p < document.getLength()) {
            char ch = document.getChar(p);
            while (p < lineEndOffset) {
                if (ch == '(' || ch == ')' || ch == ';' || ch == ',') break;
                ch = document.getChar(++p);
            }
            if (ch != ';' && ch != ',' && ch != ')') {
                replacementString = String.valueOf(replacementString) + ';';
            }
        }
        int beginIndex = replacementString.indexOf(40);
        replacementString = replacementString.substring(beginIndex);
        return replacementString;
    }

    /*
     * Exception decompiling
     */
    private String createNewBody(ImportRewrite importRewrite) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IBinding getEnclosingDeclaration(ASTNode node) {
        while (node != null) {
            IVariableBinding variableBinding;
            if (node instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)node).resolveBinding();
            }
            if (node instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            if (node instanceof MethodDeclaration) {
                return ((MethodDeclaration)node).resolveBinding();
            }
            if (node instanceof FieldDeclaration) {
                List fragments = ((FieldDeclaration)node).fragments();
                if (fragments.size() > 0) {
                    return ((VariableDeclarationFragment)fragments.get(0)).resolveBinding();
                }
            } else if (node instanceof VariableDeclarationFragment && ((variableBinding = ((VariableDeclarationFragment)node).resolveBinding()).getDeclaringMethod() != null || variableBinding.getDeclaringClass() != null)) {
                return variableBinding;
            }
            node = node.getParent();
        }
        return null;
    }

    private String createDummyType(String name) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("abstract class ");
        buffer.append(name);
        if (this.fSuperType.isInterface()) {
            buffer.append(" implements ");
        } else {
            buffer.append(" extends ");
        }
        if (this.fDeclarationSignature != null) {
            buffer.append(Signature.toString((String)this.fDeclarationSignature));
        } else {
            buffer.append(this.fSuperType.getFullyQualifiedParameterizedName());
        }
        buffer.append(" {");
        buffer.append("\n");
        buffer.append("}");
        return buffer.toString();
    }
}

