/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class ComboTextModifyRule
extends GenerationSimpleRule {
    private int textIndex;
    private String newValue;
    private Combo combo;

    @Override
    public boolean appliesTo(Event event) {
        if (!(event.widget instanceof Combo)) {
            return false;
        }
        Combo combo = (Combo)event.widget;
        return event.type == 24 && !Arrays.asList(combo.getItems()).contains(combo.getText());
    }

    @Override
    public void initializeForEvent(Event event) {
        this.combo = (Combo)event.widget;
        this.textIndex = WidgetUtils.getIndex((Control)this.combo);
        this.newValue = this.combo.getText();
    }

    public int getTextIndex() {
        return this.textIndex;
    }

    public void setTextIndex(int textIndex) {
        this.textIndex = textIndex;
    }

    @Override
    public List<String> getActions() {
        ArrayList<String> actions = new ArrayList<String>();
        StringBuilder res = new StringBuilder();
        res.append("bot.comboBox(");
        if (this.textIndex != 0) {
            res.append(this.textIndex);
        }
        res.append(").setText(\"" + this.newValue + "\")");
        actions.add(res.toString());
        return actions;
    }

    @Override
    public List<String> getImports() {
        return null;
    }

    public Combo getWidget() {
        return this.combo;
    }
}

