/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtbot.generator.framework.GenerationRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public abstract class AbstractTreeGenerationRule
extends GenerationRule {
    private Tree tree;
    private TreeItem item;

    public boolean appliesTo(Event event) {
        return event.widget instanceof Tree && event.item instanceof TreeItem;
    }

    public void initializeForEvent(Event event) {
        this.tree = (Tree)event.widget;
        this.item = (TreeItem)event.item;
    }

    protected String getWidgetAccessor() {
        StringBuilder res = new StringBuilder();
        res.append("bot.tree(");
        int index = WidgetUtils.getIndex((Control)this.tree);
        if (index != 0) {
            res.append(index);
        }
        res.append(")");
        ArrayList<String> path = new ArrayList<String>();
        TreeItem currentItem = this.item;
        while (currentItem != null) {
            if (currentItem != null && currentItem.getText() != null) {
                path.add(currentItem.getText());
            }
            currentItem = currentItem.getParentItem();
        }
        Collections.reverse(path);
        boolean first = true;
        for (String text : path) {
            if (first) {
                res.append(".getTreeItem(\"");
                first = false;
            } else {
                res.append(".getNode(\"");
            }
            res.append(text);
            res.append("\")");
        }
        return res.toString();
    }
}

