/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast.expressions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;

public class PythonDictExpression
extends Expression {
    private List fDictionary = new ArrayList();

    public PythonDictExpression() {
    }

    public PythonDictExpression(DLTKToken t) {
        super(t);
    }

    public int getKind() {
        return 38002;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Expression)this)) {
            for (DictNode node : this.fDictionary) {
                Expression value;
                Expression key = node.getKey();
                if (key != null) {
                    key.traverse(pVisitor);
                }
                if ((value = node.getValue()) == null) continue;
                value.traverse(pVisitor);
            }
            pVisitor.endvisit((Expression)this);
        }
    }

    public void putExpression(Expression key, Expression value) {
        this.fDictionary.add(new DictNode(key, value));
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("{");
        if (this.fDictionary != null) {
            boolean first = true;
            for (DictNode node : this.fDictionary) {
                Expression value;
                if (first) {
                    first = false;
                } else {
                    output.formatPrintLn(", ");
                }
                Expression key = node.getKey();
                if (key != null) {
                    key.printNode(output);
                    output.formatPrintLn(":");
                }
                if ((value = node.getValue()) == null) continue;
                value.printNode(output);
            }
        }
        output.formatPrintLn("}");
    }

    private static class DictNode {
        private Expression key;
        private Expression value;

        public DictNode(Expression key, Expression value) {
            this.key = key;
            this.value = value;
        }

        public Expression getKey() {
            return this.key;
        }

        public Expression getValue() {
            return this.value;
        }
    }
}

