/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.tcl.ast.Node;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclArgumentList;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclVisibilityUtils;
import org.eclipse.dltk.tcl.parser.TclParser;
import org.eclipse.dltk.tcl.parser.printer.SimpleCodePrinter;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;
import org.eclipse.dltk.tcl.structure.ITclModelBuilder;
import org.eclipse.dltk.tcl.structure.ITclTypeHandler;
import org.eclipse.dltk.tcl.structure.ITclTypeResolver;
import org.eclipse.dltk.tcl.structure.TclModelBuilderUtil;
import org.eclipse.dltk.tcl.structure.TclProcessorUtil;
import org.eclipse.emf.common.util.EList;

public abstract class AbstractTclCommandModelBuilder
extends TclModelBuilderUtil
implements ITclModelBuilder {
    protected void report(ITclModelBuildContext context, Node node, String message, ProblemSeverity severity) {
    }

    protected void processField(TclCommand command, TclArgument nameArg, String varName, int modifiers, ITclModelBuildContext context) {
        this.processField(command, nameArg, varName, modifiers, context, null, null);
    }

    protected void processField(TclCommand command, TclArgument nameArg, String varName, int modifiers, ITclModelBuildContext context, ITclTypeHandler exit, FieldInitializer initializer) {
        boolean needExit;
        if (varName == null) {
            varName = AbstractTclCommandModelBuilder.asSymbol(nameArg);
        }
        IElementRequestor.FieldInfo fi = new IElementRequestor.FieldInfo();
        fi.nameSourceStart = nameArg.getStart();
        fi.nameSourceEnd = nameArg.getEnd() - 1;
        fi.declarationStart = fi.nameSourceStart;
        fi.modifiers = modifiers;
        String arrayIndex = null;
        if (TclParseUtil.isArrayVariable(varName)) {
            arrayIndex = TclParseUtil.extractArrayIndex(varName);
            varName = TclParseUtil.extractArrayName(varName);
        }
        fi.name = varName;
        if (initializer != null) {
            initializer.initialize(fi);
        }
        String fullName = TclParseUtil.escapeName(varName);
        if (exit == null) {
            exit = context.get(ITclTypeResolver.class).resolveMemberType((IElementRequestor.ElementInfo)fi, command.getEnd(), fullName);
        }
        if (needExit = context.getRequestor().enterFieldCheckDuplicates(fi)) {
            if (arrayIndex != null) {
                IElementRequestor.FieldInfo fiIndex = new IElementRequestor.FieldInfo();
                fiIndex.name = String.valueOf(varName) + "(" + arrayIndex + ")";
                fiIndex.nameSourceStart = fi.nameSourceStart;
                fiIndex.nameSourceEnd = fi.nameSourceEnd;
                fiIndex.declarationStart = fi.declarationStart;
                fiIndex.modifiers = 0x2719 | fi.modifiers;
                if (context.getRequestor().enterFieldCheckDuplicates(fiIndex)) {
                    context.getRequestor().exitField(command.getEnd());
                }
            }
            context.getRequestor().exitField(command.getEnd());
        }
        exit.leave(context.getRequestor());
    }

    protected void processField(TclCommand command, TclArgument nameArg, ITclModelBuildContext context) {
        if (!AbstractTclCommandModelBuilder.isSymbol(nameArg)) {
            return;
        }
        String varName = AbstractTclCommandModelBuilder.asSymbol(nameArg);
        int modifiers = TclVisibilityUtils.isPrivate(varName) ? 16 : 64;
        this.processField(command, nameArg, varName, modifiers, context);
    }

    protected List<Parameter> parseParameters(TclArgument argument) {
        if (argument instanceof StringArgument) {
            return Collections.singletonList(new Parameter(argument));
        }
        if (argument instanceof TclArgumentList) {
            TclArgumentList list = (TclArgumentList)argument;
            ArrayList<Parameter> parameters = new ArrayList<Parameter>(list.getArguments().size());
            for (TclArgument arg : list.getArguments()) {
                if (arg instanceof StringArgument) {
                    parameters.add(new Parameter(arg));
                    continue;
                }
                if (arg instanceof TclArgumentList) {
                    EList argWithInitializer = ((TclArgumentList)arg).getArguments();
                    TclArgument pName = (TclArgument)argWithInitializer.get(0);
                    if (argWithInitializer.size() >= 2) {
                        parameters.add(new Parameter(AbstractTclCommandModelBuilder.asSymbol(pName), pName.getStart(), pName.getEnd(), TclProcessorUtil.asString((TclArgument)argWithInitializer.get(1), false)));
                        continue;
                    }
                    if (argWithInitializer.size() == 1) {
                        parameters.add(new Parameter(pName));
                        continue;
                    }
                    parameters.add(new Parameter("", arg.getStart(), arg.getEnd()));
                    continue;
                }
                parameters.add(new Parameter(arg));
            }
            return parameters;
        }
        return Collections.singletonList(new Parameter(argument));
    }

    protected void parseRawParameters(TclArgument args, List<Parameter> parameters) {
        for (TclArgument a : this.toWords(args)) {
            if (!(a instanceof StringArgument)) continue;
            String aa = ((StringArgument)a).getValue();
            if (aa.startsWith("{") && aa.endsWith("}") || aa.startsWith("\"") && aa.endsWith("\"")) {
                TclArgument first;
                List<TclArgument> parts = this.toWords(a);
                if (parts.isEmpty() || !((first = parts.get(0)) instanceof StringArgument)) continue;
                parameters.add(new Parameter(first));
                continue;
            }
            parameters.add(new Parameter(a));
        }
    }

    protected void fillParameters(IElementRequestor.MethodInfo mi, List<Parameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        mi.parameterNames = new String[parameters.size()];
        mi.parameterInitializers = new String[parameters.size()];
        int i = 0;
        while (i < parameters.size()) {
            Parameter parameter = parameters.get(i);
            mi.parameterNames[i] = parameter.name;
            mi.parameterInitializers[i] = parameter.defaultValue;
            ++i;
        }
    }

    private List<TclArgument> toWords(TclArgument argument) {
        String content;
        int offset = argument.getStart();
        if (argument instanceof StringArgument) {
            String value = ((StringArgument)argument).getValue();
            int len = value.length();
            if (len >= 2) {
                if (value.charAt(0) == '{' && value.charAt(len - 1) == '}') {
                    content = value.substring(1, len - 1);
                    ++offset;
                } else if (value.charAt(0) == '\"' && value.charAt(len - 1) == '\"') {
                    content = value.substring(1, len - 1);
                    ++offset;
                } else {
                    content = value;
                }
            } else {
                content = value;
            }
        } else {
            content = SimpleCodePrinter.getArgumentString((TclArgument)argument, (int)argument.getStart());
        }
        TclParser parser = new TclParser();
        parser.setGlobalOffset(offset);
        List commands = parser.parse(content);
        ArrayList<TclArgument> result = new ArrayList<TclArgument>();
        for (TclCommand c : commands) {
            result.add(c.getName());
            result.addAll((Collection<TclArgument>)c.getArguments());
        }
        return result;
    }

    protected static abstract class FieldInitializer {
        protected FieldInitializer() {
        }

        public abstract void initialize(IElementRequestor.FieldInfo var1);
    }

    public static class Parameter {
        final String name;
        final String defaultValue;
        final int start;
        final int end;

        public Parameter(TclArgument argument) {
            this.name = AbstractTclCommandModelBuilder.asSymbol(argument);
            this.start = argument.getStart();
            this.end = argument.getEnd();
            this.defaultValue = null;
        }

        public Parameter(String name, int start, int end) {
            this.name = name;
            this.start = start;
            this.end = end;
            this.defaultValue = null;
        }

        public Parameter(String name, int start, int end, String defaultValue) {
            this.name = name;
            this.start = start;
            this.end = end;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

