/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.SourceRefElementInfo;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;

public abstract class SourceRefElement
extends ModelElement
implements ISourceReference {
    public int occurrenceCount = 1;

    protected SourceRefElement(ModelElement parent) throws IllegalArgumentException {
        super(parent);
    }

    @Override
    protected Object createElementInfo() {
        return null;
    }

    @Override
    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws ModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent == null) {
            return;
        }
        ModelElementInfo openableParentInfo = (ModelElementInfo)ModelManager.getModelManager().getInfo(openableParent);
        if (openableParentInfo == null) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    @Override
    public IOpenable getOpenableParent() {
        IModelElement current = this.getParent();
        while (current != null) {
            if (current instanceof IOpenable) {
                return (IOpenable)current;
            }
            current = current.getParent();
        }
        return null;
    }

    @Override
    public IResource getResource() {
        return this.getParent().getResource();
    }

    @Override
    public ISourceRange getSourceRange() throws ModelException {
        SourceRefElementInfo info = (SourceRefElementInfo)this.getElementInfo();
        if (info != null) {
            return info.getSourceRange();
        }
        return null;
    }

    @Override
    public IPath getPath() {
        return this.getParent().getPath();
    }

    @Override
    public IResource getUnderlyingResource() throws ModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getParent().getUnderlyingResource();
    }

    @Override
    public boolean hasChildren() throws ModelException {
        return this.getChildren().length > 0;
    }

    @Override
    public boolean isStructureKnown() throws ModelException {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SourceRefElement)) {
            return false;
        }
        return this.occurrenceCount == ((SourceRefElement)o).occurrenceCount && super.equals(o);
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        super.toStringName(buffer);
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }

    @Override
    public IResource getCorrespondingResource() throws ModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return null;
    }

    public IModelElement getHandleUpdatingCountFromMemento(MementoTokenizer memento, WorkingCopyOwner owner) {
        if (!memento.hasMoreTokens()) {
            return this;
        }
        this.occurrenceCount = Integer.parseInt(memento.nextToken());
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
        }
        return this;
    }

    @Override
    public void getHandleMemento(StringBuffer buff) {
        super.getHandleMemento(buff);
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    @Override
    public ISourceModule getSourceModule() {
        return ((ModelElement)this.getParent()).getSourceModule();
    }

    @Override
    public String getSource() throws ModelException {
        IOpenable openable = this.getOpenableParent();
        IBuffer buffer = openable.getBuffer();
        ISourceRange range = this.getSourceRange();
        int offset = range.getOffset();
        int length = range.getLength();
        if (offset == -1 || length == 0) {
            return null;
        }
        int bufLen = -1;
        String content = null;
        if (buffer != null) {
            bufLen = buffer.getLength();
        } else if (openable instanceof ISourceModule) {
            content = ((ISourceModule)openable).getSource();
            if (content == null) {
                return null;
            }
            bufLen = content.length();
        } else {
            return null;
        }
        if (bufLen < offset + length) {
            --length;
        }
        try {
            if (buffer != null) {
                return buffer.getText(offset, length);
            }
            return content.substring(offset, offset + length);
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

