/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElementDelta;
import org.eclipse.dltk.internal.core.ModelOperation;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;

public class CreateSourceModuleOperation
extends ModelOperation {
    protected String fName;
    protected String fSource = null;

    public CreateSourceModuleOperation(IScriptFolder parentElement, String name, String source, boolean force) {
        super(null, new IModelElement[]{parentElement}, force);
        this.fName = name;
        this.fSource = source;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void executeOperation() throws ModelException {
        try {
            ModelElementDelta delta = this.newModelElementDelta();
            ISourceModule unit = this.getSourceModule();
            IScriptFolder pkg = (IScriptFolder)this.getParentElement();
            IContainer folder = (IContainer)pkg.getResource();
            this.worked(1);
            IFile compilationUnitFile = folder.getFile((IPath)new Path(this.fName));
            if (compilationUnitFile.exists()) {
                if (!this.force) throw new ModelException(new ModelStatus(977, Messages.bind(Messages.status_nameCollision, compilationUnitFile.getFullPath().toString())));
                IBuffer buffer = unit.getBuffer();
                if (buffer == null) {
                    return;
                }
                buffer.setContents(this.fSource);
                unit.save((IProgressMonitor)new NullProgressMonitor(), false);
                this.resultElements = new IModelElement[]{unit};
                if (!Util.isExcluded(unit) && unit.getParent().exists()) {
                    int i = 0;
                    while (i < this.resultElements.length) {
                        delta.changed(this.resultElements[i], 1);
                        ++i;
                    }
                    this.addDelta(delta);
                }
            } else {
                try {
                    String encoding = null;
                    try {
                        encoding = folder.getDefaultCharset();
                    }
                    catch (CoreException i) {
                        // empty catch block
                    }
                    ByteArrayInputStream stream = new ByteArrayInputStream(encoding == null ? this.fSource.getBytes() : this.fSource.getBytes(encoding));
                    this.createFile(folder, unit.getElementName(), stream, this.force);
                    this.resultElements = new IModelElement[]{unit};
                    if (!Util.isExcluded(unit) && unit.getParent().exists()) {
                        int i = 0;
                        while (i < this.resultElements.length) {
                            delta.added(this.resultElements[i]);
                            ++i;
                        }
                        this.addDelta(delta);
                    }
                }
                catch (IOException e) {
                    throw new ModelException(e, 985);
                }
            }
            this.worked(1);
            return;
        }
        finally {
            this.done();
        }
    }

    protected ISourceModule getSourceModule() {
        return ((IScriptFolder)this.getParentElement()).getSourceModule(this.fName);
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        IResource resource = this.getSourceModule().getResource();
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }

    @Override
    public IModelStatus verify() {
        if (this.getParentElement() == null) {
            return new ModelStatus(968);
        }
        if (this.fSource == null) {
            return new ModelStatus(984);
        }
        return IModelStatus.VERIFIED_OK;
    }
}

