/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.net.URI;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackagesFactory;
import org.eclipse.dltk.tcl.core.packages.TclProjectInfo;
import org.eclipse.dltk.tcl.core.packages.TclSourceEntry;
import org.eclipse.dltk.tcl.core.packages.UserCorrection;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.IAnnotationResolution;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IMarkerResolution;

final class TclSourceMarkerResolution
implements IMarkerResolution,
IAnnotationResolution {
    private String sourceName;
    private IScriptProject project;
    private ISourceModule module;

    public TclSourceMarkerResolution(String pkgName, IScriptProject scriptProject, ISourceModule module) {
        this.sourceName = pkgName;
        this.project = scriptProject;
        this.module = module;
    }

    public String getLabel() {
        return "Add user specified source file location to buildpath";
    }

    private static IPath resolveSourceValue(IPath folder, String source, IEnvironment environment) {
        IPath valuePath = null;
        if (environment.isLocal()) {
            valuePath = Path.fromOSString((String)source);
        } else {
            source = source.replace('\\', '/');
            valuePath = Path.fromPortableString((String)source);
        }
        IPath sourcedPath = null;
        if (valuePath.isAbsolute()) {
            sourcedPath = valuePath;
        } else if (TclPackagesManager.isValidName((String)source)) {
            sourcedPath = folder.append(valuePath);
        }
        return sourcedPath;
    }

    public static boolean fixAvailable(ISourceModule module, String source) {
        IPath sourcePath;
        IFileHandle file;
        URI uri;
        if (module == null || !module.exists()) {
            return false;
        }
        IEnvironment env = EnvironmentManager.getEnvironment((IModelElement)module);
        IPath modulePath = module.getPath();
        if (module.getResource() != null && (modulePath = module.getResource().getLocation()) == null && (uri = module.getResource().getLocationURI()) != null && (file = env.getFile(uri)) != null) {
            modulePath = file.getPath();
        }
        if ((sourcePath = TclSourceMarkerResolution.resolveSourceValue(modulePath.removeLastSegments(1), source, env)) == null) {
            return false;
        }
        file = env.getFile(sourcePath);
        return file != null && file.exists() && file.isFile();
    }

    private boolean resolve() {
        block5: {
            IPath sourcePath;
            block6: {
                IFileHandle file;
                URI uri;
                IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((IScriptProject)this.project);
                if (install == null) break block5;
                IEnvironment env = EnvironmentManager.getEnvironment((IModelElement)this.module);
                IPath modulePath = this.module.getPath();
                if (this.module.getResource() != null && (modulePath = this.module.getResource().getLocation()) == null && (uri = this.module.getResource().getLocationURI()) != null && (file = env.getFile(uri)) != null) {
                    modulePath = file.getPath();
                }
                if ((sourcePath = TclSourceMarkerResolution.resolveSourceValue(modulePath.removeLastSegments(1), this.sourceName, env)) != null) break block6;
                return false;
            }
            try {
                TclProjectInfo tclProject = TclPackagesManager.getTclProject((String)this.project.getElementName());
                String handle = this.module.getHandleIdentifier();
                TclModuleInfo info = tclProject.findModule(handle);
                if (info == null) {
                    info = TclPackagesFactory.eINSTANCE.createTclModuleInfo();
                    info.setHandle(handle);
                    info.setExternal(this.module instanceof IExternalSourceModule);
                    TclSourceEntry sourceEntry = TclPackagesFactory.eINSTANCE.createTclSourceEntry();
                    sourceEntry.setStart(-1);
                    sourceEntry.setEnd(-1);
                    sourceEntry.setValue(this.sourceName);
                    info.getSourced().add((Object)sourceEntry);
                    tclProject.getModules().add((Object)info);
                }
                UserCorrection correction = TclPackagesFactory.eINSTANCE.createUserCorrection();
                correction.setOriginalValue(this.sourceName);
                correction.getUserValue().add((Object)sourcePath.toString());
                info.getSourceCorrections().add((Object)correction);
                TclPackagesManager.save();
                ModelManager.getModelManager().getDeltaProcessor().checkExternalChanges(new IModelElement[]{this.project}, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                TclUI.error("require package resolve error", e);
            }
        }
        return false;
    }

    public void run(IMarker marker) {
        this.resolve();
    }

    public void run(IScriptAnnotation annotation, IDocument document) {
        this.resolve();
    }
}

