/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.scriptdoc;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;

public class BuiltinElementDocumentationProvider
implements IScriptDocumentationProvider {
    public Reader getInfo(String content) {
        return null;
    }

    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        ISourceModule module;
        IProjectFragment fragment = (IProjectFragment)element.getAncestor(3);
        if (fragment != null && fragment.isBuiltin() && (module = (ISourceModule)element.getAncestor(5)) != null && "builtins.js".equals(module.getElementName())) {
            ArrayList<String> segments = new ArrayList<String>();
            IMember e = element;
            while (e != module) {
                segments.add(0, e.getElementName());
                e = e.getParent();
            }
            TypeInferencer2 context = new TypeInferencer2();
            Type type = context.getType((String)segments.get(0));
            if (type != null) {
                if (segments.size() == 1) {
                    return BuiltinElementDocumentationProvider.documentationFor(element, (Element)type);
                }
                if (segments.size() >= 2) {
                    for (Member member : type.getMembers()) {
                        if (!((String)segments.get(1)).equals(member.getName())) continue;
                        return BuiltinElementDocumentationProvider.documentationFor(element, (Element)member);
                    }
                }
            }
        }
        return null;
    }

    private static Reader documentationFor(IMember element, Element type) {
        if (type.getDescription() != null && type.getDescription().length() != 0) {
            return new StringReader(type.getDescription());
        }
        return null;
    }
}

