/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.sh.internal.ui.text.hyperlink;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class SourceHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final String SOURCE = "source";

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion inputRegion, boolean canShowMultipleHyperlinks) {
        if (inputRegion == null || textViewer == null) {
            return null;
        }
        try {
            IHyperlink link;
            IDocument doc = textViewer.getDocument();
            int lineNumber = doc.getLineOfOffset(inputRegion.getOffset());
            IRegion region = doc.getLineInformation(lineNumber);
            String line = doc.get(region.getOffset(), region.getLength());
            if (line != null && line.length() != 0 && (link = this.checkLine(region.getOffset(), line)) != null) {
                return new IHyperlink[]{link};
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private IHyperlink checkLine(int offset, String line) {
        int begin = 0;
        int end = line.length();
        while (begin < end && Character.isWhitespace(line.charAt(begin))) {
            ++begin;
        }
        while (begin < end && Character.isWhitespace(line.charAt(end - 1))) {
            --end;
        }
        if (begin + SOURCE.length() < end && line.startsWith(SOURCE, begin)) {
            begin += SOURCE.length();
            while (begin < end && Character.isWhitespace(line.charAt(begin))) {
                ++begin;
            }
            if (begin + 2 < end && line.charAt(begin) == '(' && line.charAt(end - 1) == ')') {
                ++begin;
                --end;
                while (begin < end && Character.isWhitespace(line.charAt(begin))) {
                    ++begin;
                }
                while (begin < end && Character.isWhitespace(line.charAt(end - 1))) {
                    --end;
                }
            }
            return this.createLink(offset, line, begin, end);
        }
        return null;
    }

    private IHyperlink createLink(int offset, String line, int begin, int end) {
        ITextEditor editor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (editor != null) {
            final String requiredFile = line.substring(begin, end);
            final Region region = new Region(offset + begin, end - begin);
            IContainer container = ((FileEditorInput)((ITextEditor)this.getAdapter(ITextEditor.class)).getEditorInput()).getFile().getParent();
            final IResource resourceToOpen = container.findMember(requiredFile);
            if (resourceToOpen != null && resourceToOpen.getType() == 1) {
                return new IHyperlink(){

                    public void open() {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resourceToOpen));
                        }
                        catch (PartInitException partInitException) {
                            // empty catch block
                        }
                    }

                    public String getTypeLabel() {
                        return "Shell: source";
                    }

                    public String getHyperlinkText() {
                        return requiredFile;
                    }

                    public IRegion getHyperlinkRegion() {
                        return region;
                    }
                };
            }
        }
        return null;
    }
}

