/*******************************************************************************
 * Copyright (c) 2008 xored software, Inc.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     xored software, Inc. - initial API and Implementation (Alex Panchenko)
 *******************************************************************************/
package org.jruby.lexer.yacc;

import java.io.IOException;

import org.jruby.parser.Tokens;

public class HeredocEndTerm extends StrTerm {

	private final ISourcePosition position;

	/**
	 * @param position
	 */
	public HeredocEndTerm(ISourcePosition position) {
		this.position = position;
	}

	public int parseString(RubyYaccLexer lexer, LexerSource src)
			throws IOException {
		lexer.setValue(new Token("\"", position));
		return Tokens.tSTRING_END;
	}

}
