/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ast.expressions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.ModuleSource;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.tcl.core.ITclSourceParser;

public class TclExecuteExpression
extends Expression {
    private String fExecuteContent;

    public TclExecuteExpression(int start, int end, String content) {
        this.setStart(start);
        this.setEnd(end);
        this.fExecuteContent = content;
    }

    public int getKind() {
        return 10004;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            List statements = this.parseExpression();
            if (statements != null) {
                int i = 0;
                while (i < statements.size()) {
                    ASTNode nde = (ASTNode)statements.get(i);
                    nde.traverse(visitor);
                    ++i;
                }
            }
            visitor.endvisit((Expression)this);
        }
    }

    public String getExpression() {
        return this.fExecuteContent;
    }

    public List parseExpression() {
        return this.parseExpression(this.sourceStart() + 1);
    }

    public List parseExpression(int startFrom) {
        if (this.fExecuteContent == null) {
            return null;
        }
        String content = null;
        if (this.fExecuteContent.length() < 2) {
            return new ArrayList();
        }
        content = this.fExecuteContent.substring(1, this.fExecuteContent.length() - 1);
        ITclSourceParser parser = (ITclSourceParser)DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.tcl.core.nature");
        parser.setOffset(startFrom);
        ModuleDeclaration module = parser.parse((IModuleSource)new ModuleSource(content), null);
        return module.getStatements();
    }

    public String toString() {
        return this.fExecuteContent;
    }
}

