/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.hyperlink;

import java.util.Collections;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ModelElementHyperlink;
import org.eclipse.dltk.javascript.internal.core.codeassist.JavaScriptSelectionEngine2;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.text.JSDocTextUtils;
import org.eclipse.dltk.javascript.internal.ui.text.TypeNameNode;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeRegion;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeUtil;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.ui.actions.OpenAction;
import org.eclipse.dltk.ui.infoviews.ModelElementArray;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JSDocTypeHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion inputRegion, boolean canShowMultipleHyperlinks) {
        JSDocTypeRegion selection;
        int typeExpressionOffset;
        TypeInferencer2 inferencer2;
        ISourceModule input;
        OpenAction openAction;
        block27: {
            int end;
            int start;
            String line;
            IRegion lineRegion;
            int offset;
            block26: {
                IAction action;
                ITextEditor editor;
                block25: {
                    block24: {
                        block23: {
                            int offsetInLine;
                            block22: {
                                IDocument doc;
                                block21: {
                                    if (inputRegion == null || textViewer == null || JavaScriptSelectionEngine2.isJSDocTypeSelectionEnabled()) {
                                        return null;
                                    }
                                    doc = textViewer.getDocument();
                                    offset = inputRegion.getOffset();
                                    String contentType = TextUtilities.getContentType((IDocument)doc, (String)"__javascript_partitioning", (int)offset, (boolean)true);
                                    if ("__javascript_doc".equals(contentType) || "__javascript_comment".equals(contentType)) break block21;
                                    return null;
                                }
                                lineRegion = JSDocTextUtils.getLineRegion(doc, offset);
                                line = doc.get(lineRegion.getOffset(), lineRegion.getLength());
                                offsetInLine = offset - lineRegion.getOffset();
                                start = line.lastIndexOf(123, offsetInLine);
                                if (start >= 0) break block22;
                                return null;
                            }
                            ++start;
                            end = line.indexOf(125, offsetInLine);
                            if (end >= 0) break block23;
                            return null;
                        }
                        TypeNameNode tagName = JSDocTextUtils.getTag(line.toCharArray(), 0, start);
                        if (tagName != null && "@param".equals(tagName.value())) {
                            if (line.regionMatches(end - "=".length(), "=", 0, "=".length())) {
                                end -= "=".length();
                            }
                            if (line.regionMatches(end - "...".length(), "...", 0, "...".length())) {
                                end -= "...".length();
                            }
                            if (line.regionMatches(start, "...", 0, "...".length())) {
                                start += "...".length();
                            }
                        }
                        if ((editor = (ITextEditor)this.getAdapter(ITextEditor.class)) != null) break block24;
                        return null;
                    }
                    action = editor.getAction("OpenEditor");
                    if (action != null && action instanceof OpenAction) break block25;
                    return null;
                }
                openAction = (OpenAction)action;
                input = EditorUtility.getEditorInputModelElement((IEditorPart)editor, (boolean)false);
                if (input != null) break block26;
                return null;
            }
            inferencer2 = new TypeInferencer2();
            inferencer2.setModelElement((IModelElement)input);
            typeExpressionOffset = lineRegion.getOffset() + start;
            selection = JSDocTypeUtil.findTypeAt((TypeInferencer2)inferencer2, (String)line.substring(start, end), (int)(offset - typeExpressionOffset));
            if (selection != null) break block27;
            return null;
        }
        try {
            Type type = inferencer2.getKnownType(selection.name(), TypeMode.JSDOC);
            Object[] elements = null;
            if (type == null) {
                try {
                    ScriptModelUtil.reconcile((ISourceModule)input);
                    input.accept((IModelElementVisitor)new Visitor(selection.name()));
                }
                catch (ModelException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (ModelElementFound e) {
                    elements = new Object[]{e.element};
                }
            } else {
                IModelElement me = TypeInfoManager.convertElement((ISourceModule)input, (Element)type);
                elements = SelectionConverter.filterElements(Collections.singletonList(me != null ? me : type));
            }
            if (elements != null && elements.length > 0) {
                Region region = new Region(typeExpressionOffset + selection.start(), selection.length());
                ModelElementHyperlink link = elements.length == 1 ? new ModelElementHyperlink((IRegion)region, elements[0], openAction) : new ModelElementHyperlink((IRegion)region, (Object)new ModelElementArray(elements), openAction);
                return new IHyperlink[]{link};
            }
        }
        catch (BadLocationException e) {
            JavaScriptUI.log(e);
        }
        return null;
    }

    private static class ModelElementFound
    extends RuntimeException {
        final IModelElement element;

        public ModelElementFound(IModelElement element) {
            this.element = element;
        }
    }

    private static class Visitor
    implements IModelElementVisitor {
        private final String name;

        public Visitor(String name) {
            this.name = name;
        }

        public boolean visit(IModelElement element) {
            IMember member;
            if (element instanceof IMember && this.name.equals((member = (IMember)element).getElementName())) {
                throw new ModelElementFound(element);
            }
            return true;
        }
    }
}

