/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.sql.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dltk.core.index.sql.Container;
import org.eclipse.dltk.core.index.sql.IContainerDao;
import org.eclipse.dltk.internal.core.index.sql.h2.H2Cache;

public class H2ContainerDao
implements IContainerDao {
    private static final String Q_INSERT = "INSERT INTO CONTAINERS(PATH) VALUES(?);";
    private static final String Q_SELECT_BY_PATH = "SELECT * FROM CONTAINERS WHERE PATH=?;";
    private static final String Q_SELECT_BY_ID = "SELECT * FROM CONTAINERS WHERE ID=?;";
    private static final String Q_DELETE_BY_PATH = "DELETE FROM CONTAINERS WHERE PATH=?;";
    private static final String Q_DELETE_BY_ID = "DELETE FROM CONTAINERS WHERE ID=?;";

    public Container insert(Connection connection, String path) throws SQLException {
        Container container = this.selectByPath(connection, path);
        if (container != null) {
            return container;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement statement = connection.prepareStatement(Q_INSERT, 1);){
            int param = 0;
            statement.setString(++param, path);
            statement.executeUpdate();
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (ResultSet result = statement.getGeneratedKeys();){
                result.next();
                container = new Container(result.getInt(1), path);
                H2Cache.addContainer(container);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return container;
    }

    public Container selectByPath(Connection connection, String path) throws SQLException {
        Container container = H2Cache.selectContainerByPath(path);
        if (container != null) {
            return container;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement statement = connection.prepareStatement(Q_SELECT_BY_PATH);){
            int param = 0;
            statement.setString(++param, path);
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (ResultSet result = statement.executeQuery();){
                if (result.next()) {
                    container = new Container(result.getInt(1), result.getString(2));
                    H2Cache.addContainer(container);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return container;
    }

    public Container selectById(Connection connection, int id) throws SQLException {
        Container container = H2Cache.selectContainerById(id);
        if (container != null) {
            return container;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement statement = connection.prepareStatement(Q_SELECT_BY_ID);){
            int param = 0;
            statement.setInt(++param, id);
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (ResultSet result = statement.executeQuery();){
                if (result.next()) {
                    container = new Container(result.getInt(1), result.getString(2));
                    H2Cache.addContainer(container);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return container;
    }

    public void deleteById(Connection connection, int id) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement statement = connection.prepareStatement(Q_DELETE_BY_ID);){
            int param = 0;
            statement.setInt(++param, id);
            statement.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        H2Cache.deleteContainerById(id);
    }

    public void deleteByPath(Connection connection, String path) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement statement = connection.prepareStatement(Q_DELETE_BY_PATH);){
            int param = 0;
            statement.setString(++param, path);
            statement.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        H2Cache.deleteContainerByPath(path);
    }
}

