/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.mylyn;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.CompletionProposalCategory;
import org.eclipse.dltk.ui.text.completion.CompletionProposalComputerRegistry;
import org.eclipse.jface.preference.IPreferenceStore;

public class DLTKUiUtil {
    static final String SEPARATOR_CODEASSIST = "\u0000";
    public static final String ASSIST_MYLYN_ALL = "org.eclipse.dltk.mylyn.dltkAllProposalCategory";
    public static final String ASSIST_DLTK_ALL = "org.eclipse.dltk.ui.defaultProposalCategory";
    public static final String ASSIST_DLTK_TYPE = "org.eclipse.dltk.ui.scriptTypeProposalCategory";
    public static final String ASSIST_DLTK_TEXT = "org.eclipse.dltk.ui.textProposalCategory";
    public static final String ASSIST_DLTK_NOTYPE = "org.eclipse.dltk.ui.scriptNoTypeProposalCategory";
    private static final String ASSIST_DLTK_TEMPLATE = "org.eclipse.dltk.ui.templateProposalCategory";

    public static boolean isDefaultAssistActive(String computerId) {
        if (ASSIST_DLTK_ALL.equals(computerId)) {
            CompletionProposalCategory category = DLTKUiUtil.getProposalCategory(computerId);
            return category != null ? category.isEnabled() && category.isIncluded() : false;
        }
        Set<String> disabledIds = DLTKUiUtil.getDisabledIds(DLTKUIPlugin.getDefault().getPreferenceStore());
        return !disabledIds.contains(computerId);
    }

    public static CompletionProposalCategory getProposalCategory(String computerId) {
        List computers = CompletionProposalComputerRegistry.getDefault().getProposalCategories();
        for (Object object : computers) {
            CompletionProposalCategory proposalCategory = (CompletionProposalCategory)object;
            if (!computerId.equals(proposalCategory.getId())) continue;
            return proposalCategory;
        }
        return null;
    }

    public static void installContentAssist(IPreferenceStore javaPrefs, boolean mylynContentAssist) {
        Set<String> disabledIds = DLTKUiUtil.getDisabledIds(javaPrefs);
        if (!mylynContentAssist) {
            disabledIds.remove(ASSIST_DLTK_ALL);
            disabledIds.remove(ASSIST_DLTK_TYPE);
            disabledIds.remove(ASSIST_DLTK_NOTYPE);
            disabledIds.add(ASSIST_MYLYN_ALL);
        } else {
            disabledIds.add(ASSIST_DLTK_ALL);
            disabledIds.add(ASSIST_DLTK_TYPE);
            disabledIds.add(ASSIST_DLTK_NOTYPE);
            disabledIds.remove(ASSIST_DLTK_TEMPLATE);
            disabledIds.remove(ASSIST_DLTK_TEXT);
            disabledIds.remove(ASSIST_MYLYN_ALL);
        }
        StringBuilder sb = new StringBuilder();
        for (String id : disabledIds) {
            sb.append(id);
            sb.append(SEPARATOR_CODEASSIST);
        }
        javaPrefs.setValue("content_assist_disabled_computers", sb.toString());
        CompletionProposalComputerRegistry.getDefault().reload();
    }

    public static Set<String> getDisabledIds(IPreferenceStore javaPrefs) {
        String oldValue = javaPrefs.getString("content_assist_disabled_computers");
        StringTokenizer tokenizer = new StringTokenizer(oldValue, SEPARATOR_CODEASSIST);
        HashSet<String> disabledIds = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            disabledIds.add((String)tokenizer.nextElement());
        }
        return disabledIds;
    }
}

