/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipImploder {
    protected int dirCount;
    protected int fileCount;
    private Logger logger = Logger.getLogger("org.eclipse.actf.core");
    protected boolean verbose;
    protected String baseDir;
    protected Manifest manifest;
    protected boolean includeDirs;

    public int getDirCount() {
        return this.dirCount;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public ZipImploder() {
        this(false);
    }

    public ZipImploder(boolean bl) {
        this.setVerbose(bl);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String string) throws IOException {
        if (string != null) {
            string = new File(string).getCanonicalPath();
            string = string.replace('\\', '/');
        }
        this.baseDir = string;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public boolean getIncludeDirs() {
        return this.includeDirs;
    }

    public void setIncludeDirs(boolean bl) {
        this.includeDirs = bl;
    }

    public void process(String string, String string2, String string3) throws IOException {
        this.dirCount = 0;
        this.fileCount = 0;
        if (string != null) {
            this.processZip(string, string3);
        }
        if (string2 != null) {
            this.processJar(string2, string3);
        }
    }

    public void processJar(String string, String string2) throws IOException {
        this.processJar(string, string2, null);
    }

    public void processJar(String string, String string2, String string3) throws IOException {
        this.processJar(string, string2, string3, -1, -1);
    }

    public void processJar(String string, String string2, String string3, int n, int n2) throws IOException {
        String string4 = this.setup(string, string2);
        Manifest manifest = this.getManifest();
        JarOutputStream jarOutputStream = manifest != null ? new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(string4)), manifest) : new JarOutputStream(new BufferedOutputStream(new FileOutputStream(string4)));
        this.configure(jarOutputStream, string3, n, n2);
        this.process(jarOutputStream, new File(string2));
    }

    public void processZip(String string, String string2) throws IOException {
        this.processZip(string, string2, null);
    }

    public void processZip(String string, String string2, String string3) throws IOException {
        this.processZip(string, string2, string3, -1, -1);
    }

    public void processZip(String string, String string2, String string3, int n, int n2) throws IOException {
        String string4 = this.setup(string, string2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(string4)));
        this.configure(zipOutputStream, string3, n, n2);
        this.process(zipOutputStream, new File(string2));
    }

    protected void configure(ZipOutputStream zipOutputStream, String string, int n, int n2) {
        if (string != null) {
            zipOutputStream.setComment(string);
        }
        if (n >= 0) {
            zipOutputStream.setMethod(n);
        }
        if (n2 >= 0) {
            zipOutputStream.setLevel(n2);
        }
    }

    protected String setup(String string, String string2) throws IOException {
        File file = new File(string2);
        if (!file.exists() && !file.isDirectory()) {
            throw new IOException("source must exist and be a directory: " + file);
        }
        String string3 = file.getCanonicalPath();
        String string4 = new File(string).getCanonicalPath();
        if (this.verbose) {
            this.logger.log(Level.FINE, "\n**** Imploding " + string3 + " to " + string4);
        }
        return string4;
    }

    protected void process(ZipOutputStream zipOutputStream, File file) throws IOException {
        try {
            this.processDir(zipOutputStream, file);
        }
        finally {
            zipOutputStream.close();
        }
    }

    protected String removeDrive(String string) {
        return string.length() >= 2 && string.charAt(1) == ':' ? string.substring(2) : string;
    }

    protected String removeLead(String string) {
        if (this.baseDir != null && string.startsWith(this.baseDir) && (string = string.substring(this.baseDir.length())).length() >= 1 && (string.charAt(0) == '/' || string.charAt(0) == '\\')) {
            string = string.substring(1);
        }
        return string;
    }

    public void processDir(ZipOutputStream zipOutputStream, File file) throws IOException {
        Object object;
        String string = file.getCanonicalPath();
        string = string.replace('\\', '/');
        if (this.includeDirs) {
            if (this.baseDir == null || string.length() > this.baseDir.length()) {
                object = this.removeDrive(this.removeLead(string));
                if (object.length() > 0) {
                    object = String.valueOf(object) + '/';
                    if (this.verbose) {
                        this.logger.log(Level.FINE, "\nProcessing directory " + string + " to " + (String)object);
                    }
                    ZipEntry zipEntry = new ZipEntry((String)object);
                    zipOutputStream.putNextEntry(zipEntry);
                } else if (this.verbose) {
                    this.logger.log(Level.FINE, "\nSkipping empty path");
                }
            } else if (this.verbose) {
                this.logger.log(Level.FINE, "\nDropping " + string);
            }
        } else if (this.verbose) {
            this.logger.log(Level.FINE, "\nSkipping " + string);
        }
        ++this.dirCount;
        object = file.list();
        int n = 0;
        while (n < ((String[])object).length) {
            String string2 = object[n];
            File file2 = new File(file, string2);
            if (file2.isDirectory()) {
                this.processDir(zipOutputStream, file2);
            } else {
                this.processFile(zipOutputStream, file2);
            }
            ++n;
        }
    }

    public void processFile(ZipOutputStream zipOutputStream, File file) throws IOException {
        String string = file.getCanonicalPath();
        string = string.replace('\\', '/');
        String string2 = this.removeDrive(this.removeLead(string));
        if (this.verbose) {
            this.logger.log(Level.FINE, "Processing file " + string + " to " + string2);
        }
        ZipEntry zipEntry = new ZipEntry(string2);
        zipEntry.setTime(file.lastModified());
        zipEntry.setSize(file.length());
        zipOutputStream.putNextEntry(zipEntry);
        ++this.fileCount;
        try {
            this.copyFileEntry(zipOutputStream, file);
        }
        finally {
            zipOutputStream.closeEntry();
        }
    }

    protected void copyFileEntry(ZipOutputStream zipOutputStream, File file) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            this.copyFileEntry(zipOutputStream, dataInputStream);
        }
        catch (Throwable throwable) {
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            dataInputStream.close();
        }
        catch (IOException iOException) {}
    }

    protected void copyFileEntry(ZipOutputStream zipOutputStream, DataInputStream dataInputStream) throws IOException {
        byte[] byArray = this.readAllBytes(dataInputStream);
        this.logger.log(Level.FINE, "Writing " + byArray.length + " bytes...");
        zipOutputStream.write(byArray, 0, byArray.length);
    }

    protected byte[] readAllBytes(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[]{};
        int n = dataInputStream.available();
        while (n > 0) {
            byte[] byArray2 = new byte[n];
            int n2 = dataInputStream.read(byArray2);
            this.logger.log(Level.FINE, "readAllBytes: " + n + " vs. " + n2);
            if (n2 > 0) {
                byte[] byArray3 = new byte[byArray.length + n2];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, n2);
                byArray = byArray3;
            }
            n = dataInputStream.available();
        }
        return byArray;
    }

    protected void print(String string) {
        System.out.print(string);
    }

    public static void printHelp() {
        System.out.println();
        System.out.println("Usage: java " + ZipImploder.class.getName());
        System.out.println("       (-jar <jarName> {-manifest <manfile>} | -zip <zipName>)");
        System.out.println("       -dir <sourceDir> {-lead <leadDir>} {-doDirs} {-verbose}");
        System.out.println("Where:");
        System.out.println("  <jarName>     path to target jar");
        System.out.println("  <zipName>     path to target zip");
        System.out.println("  <manfile>     path to manifest file");
        System.out.println("  <sourceDir>   path to source directory; must exist");
        System.out.println("  <leadDir>     partial lead path to remove from stored entries; default: <sourceDir>");
        System.out.println("  <noDirs>      skip output of directory entries");
        System.out.println("  <verbose>     output progress information");
        System.out.println("Note: switch case or order is not important");
    }

    protected static void reportError(String string) {
        System.err.println(string);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length == 0) {
            ZipImploder.printHelp();
            System.exit(0);
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if (((String)object).charAt(0) == '-') {
                if (((String)(object = ((String)object).substring(1))).equalsIgnoreCase("jar")) {
                    bl = true;
                    bl2 = false;
                    bl3 = false;
                    bl4 = false;
                    bl5 = false;
                } else if (((String)object).equalsIgnoreCase("manifest")) {
                    bl = false;
                    bl2 = true;
                    bl3 = false;
                    bl4 = false;
                    bl5 = false;
                } else if (((String)object).equalsIgnoreCase("zip")) {
                    bl3 = true;
                    bl2 = false;
                    bl = false;
                    bl4 = false;
                    bl5 = false;
                } else if (((String)object).equalsIgnoreCase("dir")) {
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                    bl4 = true;
                    bl5 = false;
                } else if (((String)object).equalsIgnoreCase("lead")) {
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                    bl4 = false;
                    bl5 = true;
                } else if (((String)object).equalsIgnoreCase("noDirs")) {
                    bl7 = true;
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                    bl4 = false;
                    bl5 = false;
                } else if (((String)object).equalsIgnoreCase("verbose")) {
                    bl6 = true;
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                    bl4 = false;
                    bl5 = false;
                } else {
                    ZipImploder.reportError("Invalid switch - " + (String)object);
                }
            } else if (bl) {
                if (string2 != null) {
                    ZipImploder.reportError("Duplicate value - " + (String)object);
                }
                string2 = object;
            } else if (bl2) {
                if (string3 != null) {
                    ZipImploder.reportError("Duplicate value - " + (String)object);
                }
                string3 = object;
            } else if (bl3) {
                if (string != null) {
                    ZipImploder.reportError("Duplicate value - " + (String)object);
                }
                string = object;
            } else if (bl4) {
                if (string4 != null) {
                    ZipImploder.reportError("Duplicate value - " + (String)object);
                }
                string4 = object;
            } else if (bl5) {
                if (string5 != null) {
                    ZipImploder.reportError("Duplicate value - " + (String)object);
                }
                string5 = object;
            } else {
                ZipImploder.reportError("Too many parameters - " + (String)object);
            }
            ++n;
        }
        if (string4 == null || string == null && string2 == null) {
            ZipImploder.reportError("Missing parameters");
        }
        if (string3 != null && string != null) {
            ZipImploder.reportError("Manifests not supported on ZIP files");
        }
        if (string5 == null) {
            string5 = String.valueOf(new File(string4).getAbsolutePath().replace('\\', '/')) + '/';
        }
        if (bl6) {
            System.out.println("Effective command: " + ZipImploder.class.getName() + (string2 != null ? " -jar " + string2 + (string3 != null ? " -manifest " + string3 : "") : "") + (string != null ? " -zip " + string : "") + " -dir " + string4 + " -lead " + string5 + (bl7 ? " -noDirs" : "") + (bl6 ? " -verbose" : ""));
        }
        try {
            ZipImploder zipImploder = new ZipImploder(bl6);
            zipImploder.setBaseDir(string5);
            if (string3 != null) {
                object = new BufferedInputStream(new FileInputStream(string3));
                try {
                    zipImploder.setManifest(new Manifest((InputStream)object));
                }
                finally {
                    ((BufferedInputStream)object).close();
                }
            }
            zipImploder.setIncludeDirs(!bl7);
            zipImploder.process(string, string2, string4);
            if (bl6) {
                System.out.println("\nDone Directories=" + zipImploder.getDirCount() + " Files=" + zipImploder.getFileCount());
            }
        }
        catch (IOException iOException) {
            System.err.println("Exception - " + iOException.getMessage());
            System.exit(2);
        }
    }
}

