/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.operator;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ILowVisionOperator;

public class ColorFilterOp
implements ILowVisionOperator {
    private float redRatio = 1.0f;
    private float greenRatio = 0.9f;
    private float blueRatio = 0.6f;

    public float getRedRatio() {
        return this.redRatio;
    }

    public void setRedRatio(float f) throws LowVisionException {
        if (f < 0.0f || 1.0f < f) {
            throw new LowVisionException("Ratio is out of range: " + f);
        }
        this.redRatio = f;
    }

    public float getGreenRatio() {
        return this.greenRatio;
    }

    public void setGreenRatio(float f) throws LowVisionException {
        if (f < 0.0f || 1.0f < f) {
            throw new LowVisionException("Ratio is out of range: " + f);
        }
        this.greenRatio = f;
    }

    public float getBlueRatio() {
        return this.blueRatio;
    }

    public void setBlueRatio(float f) throws LowVisionException {
        if (f < 0.0f || 1.0f < f) {
            throw new LowVisionException("Ratio is out of range: " + f);
        }
        this.blueRatio = f;
    }

    public void setRatio(float[] fArray) throws LowVisionException {
        if (fArray.length < 3) {
            throw new LowVisionException("Array is to small.");
        }
        this.setRedRatio(fArray[0]);
        this.setGreenRatio(fArray[1]);
        this.setBlueRatio(fArray[2]);
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) throws LowVisionException {
        WritableRaster writableRaster;
        DataBufferInt dataBufferInt;
        int[] nArray;
        int n;
        WritableRaster writableRaster2 = bufferedImage.copyData(null);
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster2.getDataBuffer();
        int[] nArray2 = dataBufferInt2.getData();
        int n2 = nArray2.length;
        BufferedImage bufferedImage3 = bufferedImage2;
        if (bufferedImage2 == null) {
            bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        }
        if (n2 != (n = (nArray = (dataBufferInt = (DataBufferInt)(writableRaster = bufferedImage3.copyData(null)).getDataBuffer()).getData()).length)) {
            throw new LowVisionException("Sizes of src and dest images differ.");
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n3 = 0;
        while (n3 < n2) {
            Integer n4 = new Integer(nArray2[n3]);
            Integer n5 = null;
            n5 = (Integer)hashMap.get(n4);
            if (n5 == null) {
                n5 = new Integer(ColorFilterOp.convertColor(nArray2[n3], this.redRatio, this.greenRatio, this.blueRatio));
                hashMap.put(n4, n5);
            }
            nArray[n3] = n5;
            ++n3;
        }
        bufferedImage3.setData(writableRaster);
        return bufferedImage3;
    }

    public IInt2D filter(Int2D int2D, Int2D int2D2) throws LowVisionException {
        Int2D int2D3 = int2D2;
        if (int2D2 == null) {
            int2D3 = new Int2D(int2D.getWidth(), int2D.getHeight());
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        while (n < int2D.getHeight()) {
            int n2 = 0;
            while (n2 < int2D.getWidth()) {
                int n3 = int2D.getData()[n][n2];
                Integer n4 = new Integer(n3);
                Integer n5 = (Integer)hashMap.get(n4);
                if (n5 == null) {
                    int n6;
                    int2D3.getData()[n][n2] = n6 = ColorFilterOp.convertColor(n3, this.redRatio, this.greenRatio, this.blueRatio);
                    hashMap.put(n4, new Integer(n6));
                } else {
                    int2D3.getData()[n][n2] = n5;
                }
                ++n2;
            }
            ++n;
        }
        return int2D3;
    }

    public static int convertColor(int n, float f, float f2, float f3) throws LowVisionException {
        int n2 = n;
        int n3 = n2 & 0xFF;
        int n4 = Math.round((float)n3 * f3);
        if (n4 < 0 || 255 < n4) {
            throw new LowVisionException("New blue value is out of range: " + n4);
        }
        int n5 = n2 >> 8 & 0xFF;
        int n6 = Math.round((float)n5 * f2);
        if (n6 < 0 || 255 < n6) {
            throw new LowVisionException("New green value is out of range: " + n6);
        }
        int n7 = n2 >> 16 & 0xFF;
        int n8 = Math.round((float)n7 * f);
        if (n8 < 0 || 255 < n8) {
            throw new LowVisionException("New red value is out of range: " + n8);
        }
        n2 = n2 & 0xFF000000 | n8 << 16 | n6 << 8 | n4;
        return n2;
    }
}

