/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.launching.winrgui;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.ui.util.DNDUtils;
import org.eclipse.statet.r.launching.IRCodeSubmitConnector;
import org.eclipse.statet.r.launching.winrgui.WinRGuiConnectorPlugin;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class RGWLauncher
implements IRCodeSubmitConnector {
    private static Preference.BooleanPref PREF_SUBMIT_DIRECTLY_ENABLED = new Preference.BooleanPref("org.eclipse.statet.r.debug.winrgui", "submit_directly.enabled");
    private Clipboard fClipboard;
    private final boolean fSubmitDirectly;
    private String fExecutable;

    public RGWLauncher() throws CoreException {
        URL dir = WinRGuiConnectorPlugin.getInstance().getBundle().getEntry("/win32/RGWConnector.exe");
        this.fSubmitDirectly = (Boolean)EPreferences.getInstancePrefs().getPreferenceValue((Preference)PREF_SUBMIT_DIRECTLY_ENABLED);
        try {
            String local = FileLocator.toFileURL((URL)dir).getPath();
            File file = new File(local);
            if (!file.exists()) {
                throw new IOException("Missing File '" + file.getAbsolutePath() + "'.");
            }
            this.fExecutable = file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.debug.winrgui", -1, "Error Loading R-GUI-Windows-Connector:", (Throwable)e));
        }
    }

    public boolean submit(List<String> lines, boolean gotoConsole) throws CoreException {
        SubmitType type;
        if (lines.isEmpty()) {
            type = SubmitType.DONOTHING;
        } else if (this.fSubmitDirectly && lines.size() == 1) {
            type = SubmitType.SUBMITINPUT;
        } else {
            if (!this.copyToClipboard(lines)) {
                return false;
            }
            type = SubmitType.PASTECLIPBOARD;
        }
        this.doRunConnector(type, type == SubmitType.SUBMITINPUT ? lines : null);
        return true;
    }

    public void gotoConsole() throws CoreException {
        this.doRunConnector(SubmitType.DONOTHING, null);
    }

    private void doRunConnector(SubmitType connectorCmd, final List<String> writeToProcess) throws CoreException {
        block6: {
            final String[] processCmd = new String[]{this.fExecutable, connectorCmd.toString().toLowerCase()};
            final AtomicReference process = new AtomicReference();
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        Process p = DebugPlugin.exec((String[])processCmd, null);
                        process.set(p);
                        if (writeToProcess != null) {
                            RGWLauncher.this.writeTextToProcess(p, writeToProcess);
                        }
                        int exitCode = p.waitFor();
                        String message = null;
                        switch (exitCode) {
                            case 0: {
                                break;
                            }
                            case 100: {
                                BufferedReader reader = null;
                                try {
                                    try {
                                        reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                                        message = reader.readLine();
                                        if (message == null) {
                                            message = "Unable to detect Error";
                                        }
                                    }
                                    catch (Exception e) {
                                        message = "Unable to detect Error";
                                        if (reader == null) break;
                                        try {
                                            reader.close();
                                        }
                                        catch (Exception exception) {}
                                        break;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (reader != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    throw throwable;
                                }
                                if (reader == null) break;
                                try {
                                    reader.close();
                                }
                                catch (Exception exception) {}
                                break;
                            }
                            default: {
                                message = "Unknown Error";
                            }
                        }
                        if (message != null) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.debug.winrgui", -1, "Error when running RGui-Connector: \n" + message, null));
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                progressService.busyCursorWhile(runnable);
            }
            catch (InvocationTargetException e1) {
                Throwable cause = e1.getCause();
                if (cause instanceof CoreException) {
                    throw (CoreException)cause;
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.debug.winrgui", -1, "Unknown Error occured when running R-Gui-Connector", (Throwable)e1));
            }
            catch (InterruptedException e1) {
                Process p = (Process)process.get();
                if (p == null) break block6;
                try {
                    p.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void writeTextToProcess(Process process, List<String> text) {
        block13: {
            PrintWriter writer = null;
            try {
                try {
                    writer = new PrintWriter(new OutputStreamWriter(process.getOutputStream()));
                    int i = 0;
                    while (i < text.size()) {
                        writer.println(text.get(i));
                        ++i;
                    }
                }
                catch (Exception exception) {
                    if (writer == null) break block13;
                    try {
                        writer.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private boolean copyToClipboard(List<String> lines) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < lines.size()) {
            builder.append(lines.get(i));
            builder.append("\n");
            ++i;
        }
        if (this.fClipboard == null) {
            this.fClipboard = new Clipboard(Display.getCurrent());
        }
        return DNDUtils.setContent((Clipboard)this.fClipboard, (Object[])new String[]{builder.toString()}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
    }

    private static enum SubmitType {
        DONOTHING,
        SUBMITINPUT,
        PASTECLIPBOARD;

    }
}

