/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.launching;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.databinding.core.validation.UpdateableErrorValidator;
import org.eclipse.statet.ecommons.debug.core.util.LaunchUtils;
import org.eclipse.statet.ecommons.debug.ui.config.InputArgumentsComposite;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigTabWithDbc;
import org.eclipse.statet.ecommons.debug.ui.util.HelpRequestor;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.internal.r.console.ui.launching.RConsoleType;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.launching.core.RLaunching;
import org.eclipse.statet.r.launching.ui.REnvTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class RConsoleMainTab
extends LaunchConfigTabWithDbc {
    private final ImList<RConsoleType> types = this.loadTypes();
    private final RConsoleType defaultType = (RConsoleType)this.types.get(0);
    private final IObservableValue<RConsoleType> typeValue;
    private final IObservableValue<String> workingDirectoryValue;
    protected final IObservableValue<String> argumentsValue;
    private ComboViewer typesCombo;
    private ResourceInputComposite workingDirectoryControl;
    private RArgumentsComposite argumentsControl;
    boolean withHelp = false;
    private MenuItem helpItem;
    private ILaunchConfigurationTab rEnvTab;
    private ILaunchConfiguration configCache;

    public RConsoleMainTab() {
        Realm realm = this.getRealm();
        this.typeValue = new WritableValue(realm, (Object)this.defaultType, RConsoleType.class);
        this.workingDirectoryValue = new WritableValue(realm, (Object)"", String.class);
        this.argumentsValue = new WritableValue(realm, (Object)"", String.class);
    }

    protected ImList<RConsoleType> loadTypes() {
        ArrayList<RConsoleType> types = new ArrayList<RConsoleType>();
        types.add(new RConsoleType("RJ (default)", "local.rjs-rmi", true, true, true));
        types.add(new RConsoleType("Rterm", "local.rterm", false, false, false));
        return ImCollections.toList(types);
    }

    protected RConsoleType getType(String typeId) {
        for (RConsoleType type : this.types) {
            if (!type.getId().equals(typeId)) continue;
            return type;
        }
        return this.defaultType;
    }

    public String getName() {
        return Messages.RConsole_MainTab_name;
    }

    public Image getImage() {
        return SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/images/obj/main_tab");
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(mainComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Label label = new Label(composite, 16384);
        label.setText(String.valueOf(Messages.RConsole_MainTab_LaunchType_label) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.typesCombo = new ComboViewer(composite, 12);
        this.typesCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typesCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                RConsoleType type = (RConsoleType)element;
                return type.getName();
            }
        });
        this.typesCombo.setInput(this.types);
        this.typesCombo.getCombo().setVisibleItemCount(this.types.size());
        this.typesCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.typesCombo.getControl().setEnabled(this.types.size() > 1);
        Composite detailGroup = this.createTypeDetailGroup(mainComposite);
        if (detailGroup != null) {
            detailGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        Composite commandGroup = this.createROptionsGroup(mainComposite);
        commandGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        LayoutUtils.addSmallFiller((Composite)mainComposite, (boolean)true);
        this.createFooter(mainComposite);
        Dialog.applyDialogFont((Control)parent);
        this.initBindings();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.statet.r.ui.r_console-launch");
    }

    private Composite createROptionsGroup(Composite parent) {
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.getLaunchConfigurationDialog().getTabs();
        int n = iLaunchConfigurationTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            if (tab instanceof REnvTab) {
                this.rEnvTab = tab;
                break;
            }
            ++n2;
        }
        this.withHelp = this.rEnvTab != null && this.getLaunchConfigurationDialog() instanceof TrayDialog;
        Group group = new Group(parent, 0);
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)3));
        group.setText("R options:");
        this.workingDirectoryControl = new ResourceInputComposite((Composite)group, 4, 10, Messages.RConsole_MainTab_WorkingDir_label);
        this.workingDirectoryControl.setShowInsertVariable(true, (List)VariableFilterUtils.DEFAULT_INTERACTIVE_FILTERS, null);
        this.workingDirectoryControl.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.argumentsControl = new RArgumentsComposite((Composite)group);
        this.argumentsControl.setLayoutData(new GridData(4, 4, true, false, 3, 1));
        return group;
    }

    protected @Nullable Composite createTypeDetailGroup(Composite parent) {
        return null;
    }

    protected Composite getArgumentComposite() {
        return this.argumentsControl;
    }

    protected void createFooter(Composite composite) {
        Label note = new Label(composite, 64);
        note.setText(String.valueOf(SharedMessages.Note_label) + ": " + this.argumentsControl.getNoteText());
        note.setLayoutData((Object)new GridData(4, 1024, true, false));
    }

    protected void initBindings() {
        super.initBindings();
        this.updateType(this.defaultType);
    }

    protected void addBindings(DataBindingContext dbc) {
        UpdateableErrorValidator typeValidator = null;
        if (this.getLaunchConfigurationDialog().getMode().equals("debug")) {
            typeValidator = new UpdateableErrorValidator(type -> {
                if (!type.isDebugSupported()) {
                    return ValidationStatus.error((String)NLS.bind((String)"R launch type ''{0}'' does not support debug mode.", (Object)type.getName()));
                }
                return ValidationStatus.ok();
            });
        }
        dbc.bindValue((IObservableValue)ViewerProperties.singleSelection(RConsoleType.class).observe((Viewer)this.typesCombo), this.typeValue, typeValidator != null ? new UpdateValueStrategy().setAfterGetValidator((IValidator)typeValidator) : null, null);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.argumentsControl.getTextControl()), this.argumentsValue);
        this.workingDirectoryControl.getValidator().setOnEmpty(0);
        dbc.bindValue(this.workingDirectoryControl.getObservable(), this.workingDirectoryValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new UpdateableErrorValidator((IValidator)this.workingDirectoryControl.getValidator())), null);
        this.typeValue.addValueChangeListener((IValueChangeListener)new IValueChangeListener<RConsoleType>(){

            public void handleValueChange(ValueChangeEvent<? extends RConsoleType> event) {
                Object newValue = event.diff.getNewValue();
                RConsoleMainTab.this.updateType((RConsoleType)newValue);
            }
        });
    }

    public RConsoleType getType() {
        return (RConsoleType)this.typeValue.getValue();
    }

    protected IObservableValue<RConsoleType> getTypeValue() {
        return this.typeValue;
    }

    protected void updateType(RConsoleType type) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/type", this.defaultType.getId());
        configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/arguments.options", "");
        configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/console.pin", false);
    }

    protected void doInitialize(ILaunchConfiguration configuration) {
        String typeId = this.readAttribute(configuration, "org.eclipse.statet.r.debug/RConsole/type", "");
        this.typeValue.setValue((Object)this.getType(typeId));
        String wd = "";
        try {
            wd = REnvTab.readWorkingDirectory((ILaunchConfiguration)configuration);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        this.workingDirectoryValue.setValue((Object)wd);
        String options = this.readAttribute(configuration, "org.eclipse.statet.r.debug/RConsole/arguments.options", "");
        this.argumentsValue.setValue((Object)options);
        this.checkHelp(configuration);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.checkHelp((ILaunchConfiguration)workingCopy);
        super.activated(workingCopy);
    }

    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/type", ((RConsoleType)this.typeValue.getValue()).getId());
        if (this.argumentsControl.isEnabled()) {
            configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/arguments.options", (String)this.argumentsValue.getValue());
        } else {
            configuration.removeAttribute("org.eclipse.statet.r.debug/RConsole/arguments.options");
        }
        REnvTab.setWorkingDirectory((ILaunchConfigurationWorkingCopy)configuration, (String)((String)this.workingDirectoryValue.getValue()));
    }

    private void checkHelp(ILaunchConfiguration configuration) {
        this.configCache = configuration;
        if (this.withHelp && this.helpItem != null) {
            this.helpItem.setEnabled(this.rEnvTab.isValid(this.configCache));
        }
    }

    private void queryHelp() {
        if (!this.withHelp) {
            return;
        }
        try {
            ArrayList<String> cmdLine = new ArrayList<String>();
            ILaunchConfigurationDialog dialog = this.getLaunchConfigurationDialog();
            IREnvConfiguration renv = RLaunching.getREnvConfig((ILaunchConfiguration)this.configCache, (boolean)true);
            cmdLine.addAll(0, renv.getExecCommand(IREnvConfiguration.Exec.TERM));
            cmdLine.add("--help");
            ProcessBuilder processBuilder = new ProcessBuilder(cmdLine);
            HelpRequestor helper = new HelpRequestor(processBuilder, (TrayDialog)dialog);
            Map<String, String> envp = processBuilder.environment();
            LaunchUtils.configureEnvironment(envp, (ILaunchConfiguration)this.configCache, (Map[])new Map[]{renv.getEnvironmentsVariables()});
            dialog.run(true, true, (IRunnableWithProgress)helper);
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", -1, Messages.RConsole_MainTab_error_CannotRunHelp_message, (Throwable)e), 3);
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", -1, Messages.RConsole_MainTab_error_WhileRunningHelp_message, e.getTargetException()), 3);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void dispose() {
        if (this.withHelp) {
            HelpRequestor.closeHelpTray((TrayDialog)((TrayDialog)this.getLaunchConfigurationDialog()));
        }
        super.dispose();
    }

    private class RArgumentsComposite
    extends InputArgumentsComposite {
        public RArgumentsComposite(Composite parent) {
            super(parent);
        }

        protected void fillToolMenu(Menu menu) {
            super.fillToolMenu(menu);
            if (RConsoleMainTab.this.withHelp) {
                RConsoleMainTab.this.helpItem = new MenuItem(menu, 8);
                RConsoleMainTab.this.helpItem.setText(Messages.RConsole_MainTab_RunHelp_label);
                RConsoleMainTab.this.helpItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        RConsoleMainTab.this.queryHelp();
                        RArgumentsComposite.this.getTextControl().setFocus();
                    }
                });
                RConsoleMainTab.this.checkHelp(RConsoleMainTab.this.configCache);
            }
        }
    }
}

