/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.eval;

import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.debug.core.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.Task;
import org.eclipse.statet.r.core.model.build.RIssueReporter;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAsts;
import org.eclipse.statet.r.core.source.ast.RParser;

@NonNullByDefault
public class ExpressionValidator
implements IssueRequestor {
    private final RParser rParser = new RParser(4);
    private final RIssueReporter rProblemReporter = new RIssueReporter();
    private @Nullable String errorMessage;

    public @Nullable String checkExpression(String expression) {
        try {
            RAstNode node = this.rParser.parseExpr((TextParserInput)new StringParserInput(expression).init());
            if (node == null) {
                this.errorMessage = Messages.Expression_Validate_Detail_SingleExpression_message;
            } else if (RAsts.hasErrors((AstNode)node)) {
                SourceContent content = new SourceContent(0L, expression);
                try {
                    this.rProblemReporter.run(node, content, (IssueRequestor)this, 1);
                }
                catch (StopReporterException stopReporterException) {
                    // empty catch block
                }
                if (this.errorMessage == null) {
                    this.errorMessage = Messages.Expression_Validate_Detail_DetailMissing_message;
                }
            }
            if (this.errorMessage != null) {
                String string = NLS.bind((String)Messages.Expression_Validate_Invalid_message, (Object)this.errorMessage);
                return string;
            }
            return null;
        }
        finally {
            this.errorMessage = null;
        }
    }

    public boolean isInterestedInProblems(String categoryId) {
        return true;
    }

    public void acceptProblems(Problem problem) {
        this.errorMessage = problem.getMessage();
        throw new StopReporterException();
    }

    public void acceptProblems(String categoryId, List<Problem> problems) {
        for (Problem problem : problems) {
            this.acceptProblems(problem);
        }
    }

    public boolean isInterestedInTasks() {
        return false;
    }

    public void acceptTask(Task task) {
    }

    public void finish() {
    }

    private static class StopReporterException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

