/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.dbg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.server.dbg.Frame;

@NonNullByDefault
public class CallStack
implements RJIOExternalizable {
    public static final int FLAG_TOPFRAME = 4096;
    public static final int FLAG_NOSTEPPING = 256;
    public static final int FLAG_SOURCE = 16;
    public static final int FLAG_COMMAND = 32;
    private final List<? extends Frame> frames;

    public CallStack(List<? extends Frame> list, boolean setDefaultFlags) {
        this.frames = list;
        if (setDefaultFlags) {
            this.setDefaultFlags();
        }
    }

    public CallStack(RJIO io) throws IOException {
        int l = io.readInt();
        ArrayList<? extends Frame> list = new ArrayList<Frame>(l);
        int i = 0;
        while (i < l) {
            Frame frame = new Frame(i, io.readString());
            frame.handle = io.readLong();
            frame.fileName = io.readString();
            frame.fileTimestamp = io.readLong();
            frame.exprSrcref = io.readIntArray();
            frame.flags = io.readInt();
            list.add(frame);
            ++i;
        }
        this.frames = list;
    }

    public void writeExternal(RJIO io) throws IOException {
        int l = this.frames.size();
        io.writeInt(l);
        int i = 0;
        while (i < l) {
            Frame frame = this.frames.get(i);
            io.writeString(frame.getCall());
            io.writeLong(frame.handle);
            io.writeString(frame.fileName);
            io.writeLong(frame.fileTimestamp);
            io.writeIntArray(frame.exprSrcref, frame.exprSrcref != null ? 6 : -1);
            io.writeInt(frame.flags);
            ++i;
        }
    }

    protected void setDefaultFlags() {
        int n = this.frames.size();
        int i = 0;
        while (i < n) {
            Frame frame0 = this.frames.get(i);
            String call0 = frame0.getCall();
            if (call0 != null) {
                if (call0.startsWith("source(")) {
                    if (i + 1 < n && (frame1 = this.frames.get(i + 1)).getCall() != null && frame1.getCall().startsWith("eval.with.vis(")) {
                        frame0.addFlags(16);
                        frame1.addFlags(17);
                        if (++i + 1 < n && (frame2 = this.frames.get(i + 1)).getCall() != null && frame2.getCall().startsWith("eval.with.vis(")) {
                            frame2.addFlags(18);
                            ++i;
                        }
                    } else if (i + 2 < n && (frame1 = this.frames.get(i + 1)).getCall() != null && frame1.getCall().startsWith("withVisible(") && (frame2 = this.frames.get(i + 2)).getCall() != null && frame2.getCall().startsWith("eval(")) {
                        frame0.addFlags(16);
                        frame1.addFlags(17);
                        frame2.addFlags(18);
                        if ((i += 2) + 1 < n && (frame2 = this.frames.get(i + 1)).getCall() != null && frame2.getCall().startsWith("eval(")) {
                            frame2.addFlags(19);
                            ++i;
                        }
                    }
                } else if (call0.startsWith("rj:::.statet.evalCommand(") || call0.startsWith(".statet.evalCommand(")) {
                    frame0.addFlags(32);
                    if (i + 1 < n && (frame1 = this.frames.get(i + 1)).getCall() != null && frame1.getCall().startsWith("eval(")) {
                        frame1.addFlags(33);
                        if (++i + 1 < n && (frame2 = this.frames.get(i + 1)).getCall() != null && frame2.getCall().startsWith("eval(")) {
                            frame2.addFlags(34);
                            ++i;
                        }
                    }
                }
            }
            ++i;
        }
        this.frames.get(n - 1).addFlags(4096);
    }

    public List<? extends Frame> getFrames() {
        return this.frames;
    }

    public @Nullable Frame findFrame(long handle) {
        int i = 0;
        while (i < this.frames.size()) {
            Frame frame = this.frames.get(i);
            if (frame.getHandle() == handle) {
                return frame;
            }
            ++i;
        }
        return null;
    }
}

