/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.LtkUI;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateProposal;
import org.eclipse.statet.ltk.ui.templates.SourceEditorTemplateContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.templates.ContextTypeRegistry;

@NonNullByDefault
public abstract class TemplateCompletionComputer
implements ContentAssistComputer {
    private static final byte SELECTION_NONE = 0;
    private static final byte SELECTION_INLINE = 1;
    private static final byte SELECTION_MULTILINE = 2;
    private static final Pattern SELECTION_INLINE_PATTERN = Pattern.compile("\\$\\{word_selection\\}");
    private static final Pattern SELECTION_ANY_PATTERN = Pattern.compile("\\$\\{(?:word_selection|line_selection)\\}");
    protected static final int SELECTION_MATCH = 0x200000;
    protected final TemplateStore templateStore;
    protected final ContextTypeRegistry typeRegistry;
    private int searchMatchRules;

    public TemplateCompletionComputer(TemplateStore templateStore, ContextTypeRegistry contextTypes) {
        this.templateStore = (TemplateStore)ObjectUtils.nonNullAssert((Object)templateStore);
        this.typeRegistry = (ContextTypeRegistry)ObjectUtils.nonNullAssert((Object)contextTypes);
    }

    protected final TemplateStore getTemplateStore() {
        return this.templateStore;
    }

    protected final ContextTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    @Override
    public void onSessionStarted(SourceEditor editor, ContentAssist assist) {
        int matchRules = 4;
        if (assist.getShowSubstringMatches()) {
            matchRules |= 0x10;
        }
        this.searchMatchRules = matchRules;
    }

    @Override
    public void onSessionEnded() {
    }

    protected boolean handleRequest(int mode, String prefix) {
        return prefix != null && (prefix.length() > 0 || mode == 2);
    }

    protected int getSearchMatchRules() {
        return this.searchMatchRules;
    }

    @Override
    public void computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        SourceViewer viewer = context.getSourceViewer();
        boolean flags = false;
        String prefix = this.extractPrefix(context);
        if (!this.handleRequest(mode, prefix)) {
            return;
        }
        AssistInvocationContext region = context.getLength() == 0 ? new BasicTextRegion(context.getInvocationOffset() - prefix.length(), context.getInvocationOffset()) : context;
        SourceEditorTemplateContext templateContext = this.createTemplateContext(context, region, 0);
        if (templateContext == null) {
            return;
        }
        int count = 0;
        if (context.getLength() > 0) {
            if (prefix.length() == context.getLength()) {
                TemplateProposal.TemplateProposalParameters<AssistInvocationContext> parameters = new TemplateProposal.TemplateProposalParameters<AssistInvocationContext>(context, (TextRegion)region, new SearchPattern(this.getSearchMatchRules(), prefix), templateContext);
                count = this.computeProposals0(parameters, 0, proposals);
            }
            prefix = "";
            if (count != 0 && (templateContext = this.createTemplateContext(context, region, 0)) == null) {
                return;
            }
        }
        try {
            int selectionType = this.configureTemplateContext(context, templateContext);
            TemplateProposal.TemplateProposalParameters<AssistInvocationContext> parameters = new TemplateProposal.TemplateProposalParameters<AssistInvocationContext>(context, (TextRegion)region, new SearchPattern(this.getSearchMatchRules(), prefix), templateContext);
            this.computeProposals0(parameters, selectionType, proposals);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void computeInformationProposals(AssistInvocationContext context, AssistProposalCollector tenders, IProgressMonitor monitor) {
    }

    private int computeProposals0(TemplateProposal.TemplateProposalParameters<?> parameters, int selectionType, AssistProposalCollector proposals) {
        boolean count = false;
        List<Template> templates = this.getTemplates(parameters.templateContext.getContextType().getId());
        for (Template template : templates) {
            parameters.matchRule = 0;
            if (!this.include(template, parameters) && !this.isSelectionTemplate(selectionType, template, parameters)) continue;
            try {
                parameters.templateContext.getContextType().validate(template.getPattern());
            }
            catch (TemplateException e) {
                continue;
            }
            parameters.template = template;
            switch (parameters.matchRule) {
                case 4: {
                    parameters.baseRelevance = 20;
                    break;
                }
                case 0x200000: {
                    parameters.baseRelevance = 16;
                    break;
                }
                case 0x1000000: {
                    parameters.baseRelevance = 15;
                    break;
                }
                default: {
                    parameters.baseRelevance = -100;
                }
            }
            proposals.add(this.createProposal(parameters));
        }
        return 0;
    }

    protected boolean include(Template template, TemplateProposal.TemplateProposalParameters<?> parameters) {
        return parameters.matchesNamePattern(template.getName());
    }

    private boolean isSelectionTemplate(int selectionType, Template template, SourceProposal.ProposalParameters<?> parameters) {
        switch (selectionType) {
            case 1: {
                if (SELECTION_INLINE_PATTERN.matcher(template.getPattern()).matches()) {
                    parameters.matchRule = 0x200000;
                    return true;
                }
                return false;
            }
            case 2: {
                if (SELECTION_ANY_PATTERN.matcher(template.getPattern()).matches()) {
                    parameters.matchRule = 0x200000;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected @Nullable String extractPrefix(AssistInvocationContext context) {
        return context.getIdentifierPrefix();
    }

    protected List<Template> getTemplates(String contextTypeId) {
        return ImCollections.newList((Object[])this.templateStore.getTemplates(contextTypeId));
    }

    protected abstract @Nullable TemplateContextType getContextType(AssistInvocationContext var1, TextRegion var2);

    public @Nullable SourceEditorTemplateContext createTemplateContext(AssistInvocationContext context, TextRegion region, int flags, boolean configure) throws BadLocationException {
        SourceEditorTemplateContext templateContext = this.createTemplateContext(context, region, flags);
        if (templateContext != null && configure) {
            this.configureTemplateContext(context, templateContext);
        }
        return templateContext;
    }

    protected @Nullable SourceEditorTemplateContext createTemplateContext(AssistInvocationContext context, TextRegion region, int flags) {
        TemplateContextType contextType = this.getContextType(context, region);
        if (contextType != null) {
            return new SourceEditorTemplateContext(contextType, context.getDocument(), region, context.getEditor(), flags);
        }
        return null;
    }

    protected int configureTemplateContext(AssistInvocationContext context, SourceEditorTemplateContext templateContext) throws BadLocationException {
        int selectionType;
        IDocument document = context.getDocument();
        String text = document.get(context.getOffset(), context.getLength());
        if (text.isEmpty()) {
            selectionType = 0;
        } else {
            selectionType = text.indexOf(10) >= 0 ? 2 : 1;
            templateContext.setVariable("text", text);
        }
        templateContext.setVariable("selection", text);
        return selectionType;
    }

    protected TemplateProposal createProposal(TemplateProposal.TemplateProposalParameters<?> parameters) {
        return new TemplateProposal(parameters, this.getImage(parameters.template));
    }

    protected @Nullable Image getImage(Template template) {
        return LtkUI.getUIResources().getImage("org.eclipse.statet.ltk.ui/images/obj/text-template");
    }
}

