/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.debug.ui.launcher.LaunchShortcutUtil;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.r.launching.RCodeLaunching;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SubmitSelectionAndGotoNextLineHandler
extends AbstractHandler {
    /*
     * WARNING - void declaration
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block6: {
            IDocument document;
            void editor;
            block8: {
                IDocumentProvider documentProvider;
                block7: {
                    IWorkbenchPart workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)event);
                    ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
                    try {
                        IWorkbenchPart iWorkbenchPart = workbenchPart;
                        if (!(iWorkbenchPart instanceof ITextEditor)) break block6;
                        ITextEditor iTextEditor = (ITextEditor)iWorkbenchPart;
                        ITextEditor cfr_ignored_0 = (ITextEditor)iWorkbenchPart;
                        ISelection iSelection = selection;
                        if (!(iSelection instanceof ITextSelection)) break block6;
                        ITextSelection iTextSelection = (ITextSelection)iSelection;
                        ITextSelection cfr_ignored_1 = (ITextSelection)iSelection;
                        documentProvider = editor.getDocumentProvider();
                        if (documentProvider != null) break block7;
                        return null;
                    }
                    catch (CoreException e) {
                        LaunchShortcutUtil.handleRLaunchException(e, RLaunchingMessages.RSelectionLaunch_error_message, event);
                        return null;
                    }
                }
                document = documentProvider.getDocument((Object)editor.getEditorInput());
                if (document != null) break block8;
                return null;
            }
            List<String> lines = LaunchShortcutUtil.getSelectedCodeLines(event);
            if (lines != null) {
                void textSelection;
                RCodeLaunching.runRCodeDirect(lines, false, null);
                int newOffset = this.getNextLineOffset(document, textSelection.getEndLine());
                if (newOffset >= 0) {
                    editor.selectAndReveal(newOffset, 0);
                }
            }
            return null;
        }
        LaunchShortcutUtil.handleUnsupportedExecution(event);
        return null;
    }

    private int getNextLineOffset(IDocument doc, int endLine) {
        try {
            if (endLine >= 0 && endLine + 1 < doc.getNumberOfLines()) {
                return doc.getLineOffset(endLine + 1);
            }
            return -1;
        }
        catch (BadLocationException e) {
            RUIPlugin.logError(100, "Error while find next line.", e);
            return -1;
        }
    }
}

