/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.emf.ui.forms;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditListProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.emf.core.databinding.IEMFEditContext;
import org.eclipse.statet.ecommons.emf.ui.forms.EFProperty;
import org.eclipse.statet.ecommons.emf.ui.forms.EditCommandContributionItem;
import org.eclipse.statet.ecommons.emf.ui.forms.IEFFormPage;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.content.ElementSourceSelectionProvider;
import org.eclipse.statet.ecommons.ui.util.MenuUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class EObjectListProperty<TProperty extends EObject>
extends EFProperty {
    private ViewerUtils.TableComposite widget;
    private ButtonGroup<TProperty> buttonGroup;
    private IObservableList<TProperty> modelObservable;
    private ElementSourceSelectionProvider selectionProvider;
    private IObservableValue<@Nullable TProperty> singleSelectionObservable;

    public EObjectListProperty(String label, String tooltip, EClass eClass, EStructuralFeature eFeature) {
        super(label, tooltip, eClass, eFeature);
    }

    @Override
    public void create(Composite parent, IEFFormPage page) {
        this.widget = page.getToolkit().createPropSingleColumnTable(parent, 10, 25);
        this.widget.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.widget.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(page.getEditor().getAdapterFactory(), (Viewer)this.widget.viewer));
        this.buttonGroup = new ButtonGroup(parent);
        this.buttonGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.customizeButtonGroup(this.buttonGroup);
    }

    protected void customizeButtonGroup(ButtonGroup<TProperty> buttonGroup) {
        buttonGroup.addAddButton((ButtonGroup.SelectionHandler)new AddHandler());
        buttonGroup.addDeleteButton(null);
        buttonGroup.addSeparator();
        buttonGroup.addUpButton(null);
        buttonGroup.addDownButton(null);
    }

    @Override
    public Control getControl() {
        return this.widget;
    }

    public TableViewer getViewer() {
        return this.widget.viewer;
    }

    @Override
    public void bind(IEMFEditContext context) {
        super.bind(context);
        IEMFEditListProperty emfProperty = EMFEditProperties.list((EditingDomain)this.getEditingDomain(), (EStructuralFeature)this.getEFeature());
        this.modelObservable = emfProperty.observeDetail(this.getBaseObservable());
        ((IObserving)this.modelObservable).getObserved();
        this.widget.viewer.setInput(this.modelObservable);
        this.buttonGroup.connectTo((StructuredViewer)this.widget.viewer, this.modelObservable, null);
        EObjectListProperty.register((Control)this.widget.table, "org.eclipse.statet.ecommons.emf.ui.EObjectList");
        this.selectionProvider = new ElementSourceSelectionProvider((IPostSelectionProvider)this.widget.viewer, (Object)this);
        ViewerUtils.setSelectionProvider((Control)this.widget.table, (ISelectionProvider)this.selectionProvider);
        int operations = 19;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        this.widget.viewer.addDragSupport(19, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)this.widget.viewer));
        this.widget.viewer.addDropSupport(19, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter(this.getEditingDomain(), (Viewer)this.widget.viewer));
        this.singleSelectionObservable = ViewerProperties.singlePostSelection((Class)this.getEFeature().getEType().getInstanceClass()).observe((Viewer)this.widget.viewer);
        this.buttonGroup.updateState();
    }

    public IObservableList<TProperty> getPropertyObservable() {
        return this.modelObservable;
    }

    public IObservableValue<TProperty> getSingleSelectionObservable() {
        return this.singleSelectionObservable;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    private class AddHandler
    extends ButtonGroup.AddHandler {
        private MenuManager menuManager;

        public boolean run(IStructuredSelection selection) {
            if (this.menuManager == null) {
                this.menuManager = new MenuManager();
            } else {
                this.menuManager.removeAll();
            }
            this.fillMenu(this.menuManager);
            Menu menu = this.menuManager.createContextMenu(this.getControl());
            MenuUtils.setPullDownPosition((Menu)menu, (Control)this.getControl());
            menu.setVisible(true);
            return false;
        }

        protected void fillMenu(MenuManager menuManager) {
            EditingDomain editingDomain = EObjectListProperty.this.getEditingDomain();
            EObject base = (EObject)EObjectListProperty.this.getBaseObservable().getValue();
            if (base == null) {
                return;
            }
            Collection descriptors = editingDomain.getNewChildDescriptors((Object)base, null);
            for (Object descriptor : descriptors) {
                CommandParameter parameter;
                if (!(descriptor instanceof CommandParameter) || (parameter = (CommandParameter)descriptor).getEStructuralFeature() != EObjectListProperty.this.getEFeature()) continue;
                EditCommandContributionItem item = new EditCommandContributionItem(parameter, editingDomain, EObjectListProperty.this.getBaseObservable()){

                    @Override
                    protected void executed(Collection<?> result) {
                        EObject value;
                        Iterator<?> iter = result.iterator();
                        if (iter.hasNext() && ((AddHandler)AddHandler.this).EObjectListProperty.this.modelObservable.contains((Object)(value = (EObject)iter.next()))) {
                            ((AddHandler)AddHandler.this).EObjectListProperty.this.singleSelectionObservable.setValue((Object)value);
                        }
                    }
                };
                menuManager.add((IContributionItem)item);
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            if (this.menuManager != null) {
                this.menuManager.dispose();
            }
        }
    }

    private class LabelProvider
    extends AdapterFactoryLabelProvider {
        protected Viewer viewer;
        protected AdapterFactoryContentProvider.ViewerRefresh viewerRefresh;

        public LabelProvider(AdapterFactory adapterFactory, Viewer viewer) {
            super(adapterFactory);
            this.viewer = viewer;
        }

        /*
         * WARNING - void declaration
         */
        public void notifyChanged(Notification notification) {
            Notification notification2;
            if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed() && (notification2 = notification) instanceof IViewerNotification) {
                void viewerNotification;
                IViewerNotification iViewerNotification = (IViewerNotification)notification2;
                IViewerNotification cfr_ignored_0 = (IViewerNotification)notification2;
                if (viewerNotification.isLabelUpdate()) {
                    if (this.viewerRefresh == null) {
                        this.viewerRefresh = new AdapterFactoryContentProvider.ViewerRefresh(this.viewer);
                    }
                    if (this.viewerRefresh.addNotification((IViewerNotification)viewerNotification)) {
                        this.viewer.getControl().getDisplay().asyncExec((Runnable)this.viewerRefresh);
                    }
                }
            }
            super.notifyChanged(notification);
        }
    }
}

