/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.net.core.sshd;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jgit.transport.sshd.agent.Connector;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ecommons.net.core.ESshSettings;
import org.eclipse.statet.internal.ecommons.net.core.Messages;
import org.eclipse.statet.jcommons.collections.CopyOnWriteListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.WarningStatus;

@NonNullByDefault
public class EConnectoryFactory
implements ConnectorFactory {
    private static final Set<String> WARNED_AGENTS = new CopyOnWriteListSet();
    private final ConnectorFactory delegate;
    private final ESshSettings sshSettings;

    public EConnectoryFactory(ConnectorFactory delegate, ESshSettings settings) {
        this.delegate = delegate;
        this.sshSettings = settings;
    }

    public boolean isSupported() {
        return this.delegate.isSupported();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Collection<ConnectorFactory.ConnectorDescriptor> getSupportedConnectors() {
        return this.delegate.getSupportedConnectors();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ConnectorFactory.ConnectorDescriptor getConnector(String identityAgent) {
        for (ConnectorFactory.ConnectorDescriptor connector : this.getSupportedConnectors()) {
            if (!identityAgent.equals(connector.getIdentityAgent())) continue;
            return connector;
        }
        return null;
    }

    public ConnectorFactory.ConnectorDescriptor getDefaultConnector() {
        String identityAgent = this.sshSettings.getDefaultIdentityAgent();
        if (identityAgent != null) {
            ConnectorFactory.ConnectorDescriptor connector = this.getConnector(identityAgent);
            if (connector != null) {
                return connector;
            }
            if (WARNED_AGENTS.add(identityAgent)) {
                CommonsRuntime.log((Status)new WarningStatus("org.eclipse.statet.ecommons.net.core", NLS.bind((String)Messages.SshSession_IdentityAgent_error_Unknown_message, (Object)identityAgent)));
            }
        }
        return this.delegate.getDefaultConnector();
    }

    public Connector create(@Nullable String identityAgent, File homeDir) throws IOException {
        return this.delegate.create(identityAgent, homeDir);
    }
}

