/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.ui.editors;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.statet.docmlet.wikitext.core.ast.NodeType;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractMarkOccurrencesProvider;
import org.eclipse.swt.graphics.Point;

public class WikitextMarkOccurrencesLocator {
    public void run(AbstractMarkOccurrencesProvider.RunData run, SourceUnitModelInfo info, AstSelection astSelection, @Nullable ITextSelection orgSelection) throws BadLocationException, BadPartitioningException, UnsupportedOperationException {
        WikitextAstNode node = (WikitextAstNode)astSelection.getCovering();
        if (this.checkForAccess(run, node)) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkForAccess(AbstractMarkOccurrencesProvider.RunData run, WikitextAstNode node) throws BadLocationException {
        if (node == null || node.getNodeType() != NodeType.LABEL) {
            return false;
        }
        do {
            for (Object attachment : node.getAttachments()) {
                void access;
                Object e = attachment;
                if (!(e instanceof WikitextNameAccess)) continue;
                WikitextNameAccess cfr_ignored_0 = (WikitextNameAccess)e;
                WikitextNameAccess cfr_ignored_1 = (WikitextNameAccess)e;
                Map<Annotation, Position> annotations = this.checkDefault(run, (WikitextNameAccess)access);
                if (annotations == null) continue;
                run.set(annotations);
                return true;
            }
        } while ((node = node.getWikitextParent()) != null);
        return false;
    }

    private Map<Annotation, Position> checkDefault(AbstractMarkOccurrencesProvider.RunData run, WikitextNameAccess access) throws BadLocationException {
        while (access != null) {
            WikitextAstNode nameNode = (WikitextAstNode)access.getNameNode();
            if (nameNode == null) {
                return null;
            }
            if (run.accept(new Point(nameNode.getStartOffset(), nameNode.getEndOffset()))) {
                ImList accessList = access.getAllInUnit();
                LinkedHashMap<Annotation, Position> annotations = new LinkedHashMap<Annotation, Position>(accessList.size());
                for (WikitextNameAccess occurrence : accessList) {
                    String message = run.doc.get(((WikitextAstNode)occurrence.getNode()).getStartOffset(), ((WikitextAstNode)occurrence.getNode()).getLength());
                    annotations.put(new Annotation(occurrence.isWriteAccess() ? "org.eclipse.statet.ecommons.text.editorAnnotations.WriteOccurrences" : "org.eclipse.statet.ecommons.text.editorAnnotations.CommonOccurrences", false, message), WikitextNameAccess.getTextPosition((WikitextAstNode)((WikitextAstNode)occurrence.getNameNode())));
                }
                return annotations;
            }
            access = null;
        }
        return null;
    }
}

