/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.EditorTextInfoHoverProxy;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverDescriptor;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.ui.editors.RSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;

@NonNullByDefault
public class REditorTextHover
extends EditorTextInfoHoverProxy {
    private @Nullable RHeuristicTokenScanner scanner;

    public REditorTextHover(RSourceEditor editor, InfoHoverDescriptor descriptor, SourceEditorViewerConfiguration config) {
        super(descriptor, config);
    }

    public RSourceEditor getEditor() {
        return (RSourceEditor)super.getEditor();
    }

    private RHeuristicTokenScanner getScanner() {
        RHeuristicTokenScanner scanner = this.scanner;
        if (scanner == null) {
            this.scanner = scanner = RHeuristicTokenScanner.create((DocContentSections)this.getEditor().getDocumentContentInfo());
        }
        return scanner;
    }

    public @Nullable IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        try {
            ITypedRegion partition;
            ITypedRegion partition2;
            RHeuristicTokenScanner scanner = this.getScanner();
            IDocument document = (IDocument)ObjectUtils.nonNullAssert((Object)textViewer.getDocument());
            scanner.configure(document);
            IRegion word = scanner.findRWord(offset, false, true);
            if (word != null && (RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches((partition2 = scanner.getPartition(word.getOffset())).getType()) || partition2.getType() == "R.String" || partition2.getType() == "R.QuotedSymbol")) {
                return word;
            }
            char c = document.getChar(offset);
            if (c == '[' && RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches((partition = scanner.getPartition(offset)).getType())) {
                return new Region(offset, 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected @Nullable AssistInvocationContext createContext(IRegion region, String contentType, IProgressMonitor monitor) {
        RHeuristicTokenScanner scanner = this.getScanner();
        RAssistInvocationContext context = new RAssistInvocationContext(this.getEditor(), region, contentType, scanner, monitor);
        if (context.getAstInfo() == null) {
            return null;
        }
        return context;
    }
}

