/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Position;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.ui.refactoring.ChangeExceptionHandler;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ltk.ui.refactoring.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.ScheduledRefactoring;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressService;

@NonNullByDefault
public class RefactoringExecutionHelper {
    private final Refactoring refactoring;
    private final IProgressService execContext;
    private final Shell parentShell;
    private final int stopSeverity;
    private @Nullable SourceUnit insertPositionSourceUnit;
    private @Nullable Position insertPosition;

    public RefactoringExecutionHelper(Refactoring refactoring, int stopSeverity, Shell parentShell, IProgressService context) {
        this.refactoring = (Refactoring)ObjectUtils.nonNullAssert((Object)refactoring);
        this.stopSeverity = stopSeverity;
        this.parentShell = (Shell)ObjectUtils.nonNullAssert((Object)parentShell);
        this.execContext = (IProgressService)ObjectUtils.nonNullAssert((Object)context);
    }

    public void perform(boolean forkChangeExecution, boolean cancelable) throws InterruptedException, InvocationTargetException {
        AtomicReference op = new AtomicReference();
        try {
            this.execContext.busyCursorWhile(monitor -> {
                SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)this.refactoring.getName(), (int)10);
                IJobManager manager = Job.getJobManager();
                Thread workingThread = Thread.currentThread();
                IWorkspaceRoot rule = this.refactoring instanceof ScheduledRefactoring ? ((ScheduledRefactoring)this.refactoring).getSchedulingRule() : ResourcesPlugin.getWorkspace().getRoot();
                manager.beginRule((ISchedulingRule)rule, (IProgressMonitor)m.newChild(1));
                try {
                    if (cancelable && monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.refactoring.setValidationContext((Object)this.parentShell);
                    RefactoringStatus status = this.refactoring.checkAllConditions((IProgressMonitor)m.newChild(1, 0));
                    if (status.getSeverity() >= this.stopSeverity) {
                        AtomicBoolean canceled = new AtomicBoolean();
                        this.parentShell.getDisplay().syncExec(() -> {
                            Dialog dialog = RefactoringUI.createRefactoringStatusDialog((RefactoringStatus)status, (Shell)this.parentShell, (String)this.refactoring.getName(), (boolean)false);
                            int selection = dialog.open();
                            canceled.set(selection == 1);
                        });
                        if (canceled.get()) {
                            throw new OperationCanceledException();
                        }
                    }
                    Change change = this.refactoring.createChange((IProgressMonitor)m.newChild(2, 0));
                    change.initializeValidationData((IProgressMonitor)m.newChild(1, 0));
                    SourceUnitChange insertTracker = this.insertPositionSourceUnit != null ? this.search(change) : null;
                    PerformChangeOperation operation = new PerformChangeOperation(change);
                    operation.setUndoManager(RefactoringCore.getUndoManager(), this.refactoring.getName());
                    operation.setSchedulingRule((ISchedulingRule)rule);
                    if (cancelable && monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    op.set(operation);
                    if (forkChangeExecution) {
                        operation.run((IProgressMonitor)m.newChild(4, 0));
                    } else {
                        AtomicReference opException = new AtomicReference();
                        Display display = this.parentShell.getDisplay();
                        manager.transferRule((ISchedulingRule)rule, display.getThread());
                        display.syncExec(() -> RefactoringExecutionHelper.lambda$2(manager, (ISchedulingRule)rule, workingThread, operation, m, opException));
                        if (opException.get() != null) {
                            Exception e = (Exception)opException.get();
                            if (e instanceof CoreException) {
                                throw (CoreException)((Object)((Object)e));
                            }
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                        }
                    }
                    RefactoringStatus validationStatus = operation.getValidationStatus();
                    if (validationStatus != null && validationStatus.hasFatalError()) {
                        MessageDialog.openError((Shell)this.parentShell, (String)this.refactoring.getName(), (String)NLS.bind((String)Messages.ExecutionHelper_CannotExecute_message, (Object)validationStatus.getMessageMatchingSeverity(4)));
                        return;
                    }
                    try {
                        if (insertTracker != null) {
                            this.insertPosition = insertTracker.getInsertPosition();
                        }
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                    catch (RuntimeException | CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    manager.endRule((ISchedulingRule)rule);
                    this.refactoring.setValidationContext(null);
                }
            });
        }
        catch (InvocationTargetException e) {
            PerformChangeOperation operation = (PerformChangeOperation)op.get();
            if (operation != null && operation.changeExecutionFailed()) {
                ChangeExceptionHandler handler = new ChangeExceptionHandler(this.parentShell, this.refactoring);
                Throwable inner = e.getTargetException();
                if (inner instanceof RuntimeException) {
                    handler.handle(operation.getChange(), (RuntimeException)inner);
                }
                if (inner instanceof CoreException) {
                    handler.handle(operation.getChange(), (CoreException)inner);
                }
                throw e;
            }
            throw e;
        }
    }

    public void enableInsertPosition(SourceUnit su) {
        this.insertPositionSourceUnit = su;
    }

    public @Nullable Position getInsertPosition() {
        return this.insertPosition;
    }

    private @Nullable SourceUnitChange search(Change change) {
        if (change instanceof SourceUnitChange && ((SourceUnitChange)change).getSourceUnit() == this.insertPositionSourceUnit) {
            return (SourceUnitChange)change;
        }
        if (change instanceof CompositeChange) {
            Change[] children = ((CompositeChange)change).getChildren();
            int i = 0;
            while (i < children.length) {
                SourceUnitChange child = this.search(children[i]);
                if (child != null) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    private static /* synthetic */ void lambda$2(IJobManager iJobManager, ISchedulingRule iSchedulingRule, Thread thread, PerformChangeOperation performChangeOperation, SubMonitor subMonitor, AtomicReference atomicReference) {
        try {
            try {
                performChangeOperation.run((IProgressMonitor)subMonitor.newChild(4, 0));
            }
            catch (RuntimeException | CoreException e) {
                atomicReference.set(e);
                iJobManager.transferRule(iSchedulingRule, thread);
            }
        }
        finally {
            iJobManager.transferRule(iSchedulingRule, thread);
        }
    }
}

