/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services.util;

import java.io.OutputStream;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RService;

public abstract class Graphic {
    public static final String UNIT_PX = "px";
    public static final String UNIT_IN = "in";
    public static final String UNIT_CM = "cm";
    public static final String UNIT_MM = "mm";
    String sizeUnit;
    double sizeWidth;
    double sizeHeight;
    int resolution = -1;

    protected Graphic() {
    }

    public void setSize(double width, double height, String unit) {
        this.sizeWidth = width;
        this.sizeHeight = height;
        this.sizeUnit = unit;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public byte[] create(FunctionCall plot, RService service, ProgressMonitor m) throws StatusException {
        String filename = "plot-" + System.nanoTime() + ".plot";
        this.prepare(filename, service, m);
        plot.evalVoid(m);
        service.evalVoid("dev.off()", m);
        return service.downloadFile(filename, 0, m);
    }

    public void create(FunctionCall plot, OutputStream out, RService service, ProgressMonitor m) throws StatusException {
        String filename = "plot-" + System.nanoTime() + ".plot";
        this.prepare(filename, service, m);
        plot.evalVoid(m);
        service.evalVoid("dev.off()", m);
        service.downloadFile(out, filename, 0, m);
    }

    public byte[] create(String plotCommand, RService service, ProgressMonitor m) throws StatusException {
        String filename = "plot-" + System.nanoTime() + ".plot";
        this.prepare(filename, service, m);
        service.evalVoid(plotCommand, m);
        service.evalVoid("dev.off()", m);
        return service.downloadFile(filename, 0, m);
    }

    public void create(String plotCommand, OutputStream out, RService service, ProgressMonitor m) throws StatusException {
        String filename = "plot-" + System.nanoTime() + ".plot";
        this.prepare(filename, service, m);
        service.evalVoid(plotCommand, m);
        service.evalVoid("dev.off()", m);
        service.downloadFile(out, filename, 0, m);
    }

    protected abstract void prepare(String var1, RService var2, ProgressMonitor var3) throws StatusException;
}

