/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net.core.ssh;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.Duration;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.net.core.PortForwardingL;
import org.eclipse.statet.jcommons.net.core.RemoteClientSession;
import org.eclipse.statet.jcommons.net.core.RemoteProcess;
import org.eclipse.statet.jcommons.net.core.RemoteSocket;
import org.eclipse.statet.jcommons.net.core.TunnelClientSocketImpl;
import org.eclipse.statet.jcommons.net.core.ssh.SshClientSession;
import org.eclipse.statet.jcommons.net.core.ssh.SshTarget;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.ProcessConfig;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public abstract class BasicSshClientSession<TSession>
implements SshClientSession {
    private static final byte CONNECTING = 1;
    private static final byte CONNECTED = 2;
    private static final byte DISCONNECTED = 3;
    private final SshTarget target;
    private volatile byte state;
    private volatile @Nullable TSession session;
    private final CopyOnWriteIdentityListSet<RemoteClientSession.Listener> listeners = new CopyOnWriteIdentityListSet();
    private final @Nullable Duration timeout;

    public BasicSshClientSession(SshTarget target, @Nullable Duration timeout) {
        this.target = target;
        this.timeout = timeout;
    }

    @Override
    public SshTarget getTarget() {
        return this.target;
    }

    @Override
    public void addListener(RemoteClientSession.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(RemoteClientSession.Listener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners(RemoteClientSession.Event event) {
        for (RemoteClientSession.Listener listener : this.listeners) {
            try {
                listener.onSessionChanged(event);
            }
            catch (RuntimeException e) {
                ObjectUtils.ToStringBuilder sb = this.buildToString();
                sb.addProp("listener", listener);
                sb.addProp("event", event);
                sb.getStringBuilder().insert(0, "An error occurred while notifiying a listener of: ");
                CommonsRuntime.log(new ErrorStatus("org.eclipse.statet.jcommons.util", sb.toString(), e));
            }
        }
    }

    @Override
    public boolean isConnected() {
        TSession session;
        if (this.state == 2 && (session = this.session) != null) {
            if (this.isConnected(session)) {
                return true;
            }
            this.disconnect();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnected(TSession session) {
        BasicSshClientSession basicSshClientSession = this;
        synchronized (basicSshClientSession) {
            if (this.state != 1) {
                throw new IllegalStateException();
            }
            this.state = (byte)2;
            this.session = session;
        }
    }

    protected boolean isConnected(TSession session) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ProgressMonitor m) throws StatusException {
        try {
            BasicSshClientSession basicSshClientSession = this;
            synchronized (basicSshClientSession) {
                this.state = 1;
            }
            TSession session = this.connect(this.timeout, m);
            this.setConnected(session);
        }
        catch (Exception e) {
            StatusException se;
            this.disconnect(e);
            if (e instanceof StatusException && (se = (StatusException)e).getStatus().getSeverity() == 8) {
                throw se;
            }
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", "Failed to connect to remote host.", e));
        }
    }

    @Override
    public void disconnect() {
        this.disconnect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect(@Nullable Exception reason) {
        TSession session;
        BasicSshClientSession basicSshClientSession = this;
        synchronized (basicSshClientSession) {
            if (this.state == 3) {
                return;
            }
            session = this.session;
            this.state = (byte)3;
            this.session = null;
        }
        try {
            try {
                this.disconnect(session);
            }
            catch (Exception e) {
                if (reason != null) {
                    reason.addSuppressed(e);
                } else {
                    CommonsRuntime.log(new ErrorStatus("org.eclipse.statet.jcommons.util", "Failed to close SSH session.", e));
                }
                this.notifyListeners(new RemoteClientSession.Event(RemoteClientSession.Event.Type.DISCONNECT, this));
            }
        }
        finally {
            this.notifyListeners(new RemoteClientSession.Event(RemoteClientSession.Event.Type.DISCONNECT, this));
        }
    }

    protected abstract TSession connect(@Nullable Duration var1, ProgressMonitor var2) throws Exception;

    protected abstract void disconnect(@Nullable TSession var1) throws Exception;

    protected final @Nullable TSession getSession() {
        return this.session;
    }

    protected final TSession checkSession() throws StatusException {
        TSession session = this.session;
        if (session == null) {
            throw new StatusException(new InfoStatus("org.eclipse.statet.jcommons.util", "SSH session is closed."));
        }
        return session;
    }

    protected InetSocketAddress createTargetLocalhostAddress(Port port) {
        return InetSocketAddress.createUnresolved(this.getTargetLocalhostString(), port.get());
    }

    @Override
    public RemoteProcess exec(ProcessConfig processConfig, ProgressMonitor m) throws StatusException {
        try {
            TSession session = this.checkSession();
            return this.exec(session, processConfig, this.timeout, m);
        }
        catch (Exception e) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", "Failed to execute remote command.", e));
        }
    }

    protected abstract RemoteProcess exec(TSession var1, ProcessConfig var2, @Nullable Duration var3, ProgressMonitor var4) throws Exception;

    @Override
    public Socket createDirectTcpIpSocket(InetSocketAddress targetAddress, ProgressMonitor m) throws StatusException {
        try {
            TSession session = this.checkSession();
            TunnelClientSocketImpl socketImpl = this.createDirectTcpIpSocketImpl(session);
            RemoteSocket socket = new RemoteSocket(socketImpl);
            socket.connect(targetAddress, this.timeout, m);
            return socket;
        }
        catch (Exception e) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", "Failed to execute remote command.", e));
        }
    }

    @Override
    public Socket createDirectTcpIpSocket(Port targetPort, ProgressMonitor m) throws StatusException {
        return this.createDirectTcpIpSocket(this.createTargetLocalhostAddress(targetPort), m);
    }

    protected abstract TunnelClientSocketImpl createDirectTcpIpSocketImpl(TSession var1) throws Exception;

    @Override
    public PortForwardingL startPortForwardingL(InetSocketAddress targetAddress) throws StatusException {
        try {
            TSession session = this.checkSession();
            InetSocketAddress localAddress = this.startPortForwardingL(session, targetAddress, this.timeout);
            return new PortForwardingL(targetAddress, localAddress);
        }
        catch (Exception e) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", "Failed to start local port forwarding.", e));
        }
    }

    @Override
    public PortForwardingL startPortForwardingL(Port targetPort) throws StatusException {
        return this.startPortForwardingL(this.createTargetLocalhostAddress(targetPort));
    }

    @Override
    public void stopPortForwarding(PortForwardingL handle) throws StatusException {
        try {
            TSession session = this.getSession();
            if (session == null) {
                return;
            }
            this.stopPortForwardingL(session, handle.getTargetAddress(), handle.getLocalAddress(), this.timeout);
        }
        catch (Exception e) {
            if (this.state != 2) {
                return;
            }
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", "Failed to stop local port forwarding.", e));
        }
    }

    protected abstract InetSocketAddress startPortForwardingL(TSession var1, InetSocketAddress var2, @Nullable Duration var3) throws Exception;

    protected abstract void stopPortForwardingL(TSession var1, InetSocketAddress var2, InetSocketAddress var3, @Nullable Duration var4) throws Exception;

    public String toString() {
        return this.buildToString().toString();
    }

    protected ObjectUtils.ToStringBuilder buildToString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(SshClientSession.class, this.getClass());
        sb.addProp("target", this.target);
        return sb;
    }
}

