/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.intable.css.properties;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigAttribute;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.style.BorderStyle;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.core.style.Style;
import org.eclipse.statet.internal.r.ui.intable.DataTable;
import org.eclipse.statet.internal.r.ui.intable.css.dom.TableCellElement;
import org.eclipse.statet.internal.r.ui.intable.css.dom.TableElement;
import org.eclipse.statet.internal.r.ui.intable.css.dom.TableRegionElement;
import org.eclipse.statet.internal.r.ui.intable.css.properties.AbstractDataTablePropertyHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.Color;
import org.w3c.dom.css.CSSValue;

@NonNullByDefault
public class TableCellPropertyHandler
extends AbstractDataTablePropertyHandler {
    public @Nullable String retrieveCSSProperty(Object element, String property, @Nullable String pseudo, CSSEngine engine) throws Exception {
        block11: {
            if (!(element instanceof TableCellElement)) {
                return null;
            }
            TableCellElement cellElement = (TableCellElement)((Object)element);
            DisplayMode displayMode = TableCellPropertyHandler.getDisplayMode(cellElement, pseudo);
            String label = TableCellPropertyHandler.getOverrideLabel(cellElement, pseudo);
            if (displayMode == null) break block11;
            switch (property) {
                case "background-color": {
                    return TableCellPropertyHandler.receiveCellStyleAttribute(cellElement, displayMode, label, CellStyling.BACKGROUND_COLOR, Color.class, engine);
                }
                case "color": {
                    return TableCellPropertyHandler.receiveCellStyleAttribute(cellElement, displayMode, label, CellStyling.FOREGROUND_COLOR, Color.class, engine);
                }
            }
        }
        return null;
    }

    public boolean applyCSSProperty(Object element, String property, CSSValue value, @Nullable String pseudo, CSSEngine engine) throws Exception {
        block14: {
            if (!(element instanceof TableCellElement)) {
                return false;
            }
            TableCellElement cellElement = (TableCellElement)((Object)element);
            DisplayMode displayMode = TableCellPropertyHandler.getDisplayMode(cellElement, pseudo);
            String label = TableCellPropertyHandler.getOverrideLabel(cellElement, pseudo);
            if (displayMode == null) break block14;
            switch (property) {
                case "background-color": {
                    TableCellPropertyHandler.applyCellStyleAttribute(cellElement, displayMode, label, CellStyling.BACKGROUND_COLOR, Color.class, value, engine);
                    return true;
                }
                case "color": {
                    TableCellPropertyHandler.applyCellStyleAttribute(cellElement, displayMode, label, CellStyling.FOREGROUND_COLOR, Color.class, value, engine);
                    return true;
                }
                case "border-color": {
                    TableCellPropertyHandler.applyCellStyleBorderAttribute(cellElement, displayMode, label, (ConfigAttribute<BorderStyle>)CellStyling.BORDER_STYLE, Color.class, value, engine);
                    return true;
                }
            }
        }
        return true;
    }

    private static @Nullable DisplayMode getDisplayMode(TableCellElement cellElement, @Nullable String pseudo) {
        if (pseudo == null) {
            return DisplayMode.NORMAL;
        }
        switch (pseudo) {
            case "fully-selected": 
            case "selected": {
                return DisplayMode.SELECTED;
            }
        }
        return null;
    }

    private static @Nullable String getOverrideLabel(TableCellElement cellElement, @Nullable String pseudo) {
        block11: {
            String cssClass;
            if (pseudo == null) {
                return null;
            }
            if (!pseudo.equals("fully-selected") || (cssClass = ((TableRegionElement)cellElement.getParentNode()).getCSSClass()) == null) break block11;
            switch (cssClass) {
                case "COLUMN_HEADER_LABEL": {
                    return "COLUMN_HEADER_FULL";
                }
                case "ROW_HEADER_LABEL": {
                    return "ROW_HEADER_FULL";
                }
            }
        }
        return null;
    }

    private static <T> @Nullable String receiveCellStyleAttribute(TableCellElement cellElement, DisplayMode displayMode, @Nullable String label, ConfigAttribute<T> attribute, Class<T> valueType, CSSEngine engine) throws Exception {
        Style style;
        TableRegionElement regionElement = (TableRegionElement)cellElement.getParentNode();
        DataTable dataTable = (DataTable)((TableElement)regionElement.getParentNode()).getNativeWidget();
        if (label == null) {
            label = cellElement.getCSSClass();
        }
        if (label == null) {
            label = regionElement.getCSSClass();
        }
        if ((style = (Style)dataTable.getConfigRegistry().getSpecificAttribute(CellConfigAttributes.CELL_STYLE, displayMode, label)) != null) {
            Object value = style.getAttributeValue(attribute);
            return engine.convert(value, valueType, null);
        }
        return null;
    }

    private static <T> void applyCellStyleAttribute(TableCellElement cellElement, DisplayMode displayMode, @Nullable String label, ConfigAttribute<T> attribute, Class<T> valueType, CSSValue cssValue, CSSEngine engine) throws Exception {
        Object value;
        Object oldValue;
        Style style;
        TableRegionElement regionElement = (TableRegionElement)cellElement.getParentNode();
        DataTable dataTable = (DataTable)((TableElement)regionElement.getParentNode()).getNativeWidget();
        if (label == null) {
            label = cellElement.getCSSClass();
        }
        if (label == null) {
            label = regionElement.getCSSClass();
        }
        if ((style = (Style)dataTable.getConfigRegistry().getSpecificAttribute(CellConfigAttributes.CELL_STYLE, displayMode, label)) != null && (oldValue = style.getAttributeValue(attribute)) != null && (value = engine.convert(cssValue, valueType, (Object)dataTable.getDisplay())) != null && !value.equals(oldValue)) {
            style.setAttributeValue(attribute, value);
        }
    }

    private static <T> void applyCellStyleBorderAttribute(TableCellElement cellElement, DisplayMode displayMode, @Nullable String label, ConfigAttribute<BorderStyle> attribute, Class<T> valueType, CSSValue cssValue, CSSEngine engine) throws Exception {
        BorderStyle oldBorderStyle;
        Style style;
        TableRegionElement regionElement = (TableRegionElement)cellElement.getParentNode();
        DataTable dataTable = (DataTable)((TableElement)regionElement.getParentNode()).getNativeWidget();
        if (label == null) {
            label = cellElement.getCSSClass();
        }
        if (label == null) {
            label = regionElement.getCSSClass();
        }
        if ((style = (Style)dataTable.getConfigRegistry().getSpecificAttribute(CellConfigAttributes.CELL_STYLE, displayMode, label)) != null && (oldBorderStyle = (BorderStyle)style.getAttributeValue(CellStyling.BORDER_STYLE)) != null) {
            T value = TableCellPropertyHandler.toSWT(cssValue, valueType, engine, dataTable);
            BorderStyle borderStyle = null;
            if (valueType == Color.class && value != null && !value.equals(oldBorderStyle.getColor())) {
                borderStyle = new BorderStyle(oldBorderStyle.getThickness(), (Color)value, oldBorderStyle.getLineStyle(), oldBorderStyle.getOffset());
            }
            if (borderStyle != null) {
                style.setAttributeValue(CellStyling.BORDER_STYLE, borderStyle);
            }
        }
    }
}

