/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.data;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.RStore;

@NonNullByDefault
public class RValueFormatter {
    protected static final String NA_STRING = "NA";
    protected static final String NUM_INF_STRING = "Inf";
    protected static final String NUM_NAN_STRING = "NaN";
    protected static final String NAME_NA_STRING = "<NA>";
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final DecimalFormatSymbols NUM_SYMBOLS;
    private final StringBuilder sb = new StringBuilder(80);
    private @Nullable DecimalFormat numFormat;

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.ENGLISH);
        symbols.setExponentSeparator("e");
        symbols.setNaN(NUM_NAN_STRING);
        symbols.setInfinity(NUM_INF_STRING);
        NUM_SYMBOLS = symbols;
    }

    public void clear() {
        this.sb.setLength(0);
    }

    public void append(String s) {
        this.sb.append(s);
    }

    public void append(char c) {
        this.sb.append(c);
    }

    private void append(String s, int start, int end) {
        switch (end - start) {
            case 0: {
                return;
            }
            case 1: {
                this.sb.append(s.charAt(start));
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.sb.append(s, start, end);
                return;
            }
        }
        this.sb.append(s.substring(start, end));
    }

    public final String getString() {
        return this.sb.toString();
    }

    private void appendUIntHex(int value) {
        int pos = Math.max((32 - Integer.numberOfLeadingZeros(value) + 3) / 4 - 1, 0);
        do {
            this.sb.append(DIGITS[value >>> 4 * pos & 0xF]);
        } while (--pos >= 0);
    }

    private void appendUIntHex2(byte value) {
        this.sb.append(DIGITS[value >>> 4 & 0xF]);
        this.sb.append(DIGITS[value & 0xF]);
    }

    public void appendNA() {
        this.sb.append(NA_STRING);
    }

    public void appendInt(int integer) {
        this.sb.append(integer);
    }

    public void appendNum(double value) {
        this.sb.append(this.formatNum(value));
    }

    private String formatNum(double value) {
        double abs;
        if (this.numFormat == null) {
            this.numFormat = this.createNumFormat();
        }
        this.numFormat.setScientificNotation(value != 0.0 && ((abs = Math.abs(value)) < 1.0E-4 || abs >= 100000.0));
        return this.numFormat.format(value);
    }

    protected DecimalFormat createNumFormat() {
        DecimalFormat format = new DecimalFormat("0.0###################", NUM_SYMBOLS);
        format.setDecimalSeparatorAlwaysShown(true);
        format.setGroupingUsed(false);
        format.setExponentSignAlwaysShown(true);
        format.setSignificantDigitsUsed(false);
        return format;
    }

    private boolean isPrintableChar(int cp) {
        return UCharacter.isPrintable((int)cp);
    }

    private void appendEscapedCodepoint(int cp) {
        this.sb.append(cp <= 65535 ? "\\u{" : "\\U{");
        this.appendUIntHex(cp);
        this.sb.append('}');
    }

    private int getEscapedCodepointLength(int cp) {
        return 4 + Math.max((32 - Integer.numberOfLeadingZeros(cp) + 3) / 4, 1);
    }

    private void appendEscapedQuoteD(String value) {
        int idx;
        int start = idx = 0;
        while (idx < value.length()) {
            char c = value.charAt(idx);
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    this.append(value, start, idx);
                    this.appendEscapedCodepoint(c);
                    start = ++idx;
                    break;
                }
                case '\u0007': {
                    this.append(value, start, idx);
                    this.sb.append("\\a");
                    start = ++idx;
                    break;
                }
                case '\b': {
                    this.append(value, start, idx);
                    this.sb.append("\\b");
                    start = ++idx;
                    break;
                }
                case '\t': {
                    this.append(value, start, idx);
                    this.sb.append("\\t");
                    start = ++idx;
                    break;
                }
                case '\n': {
                    this.append(value, start, idx);
                    this.sb.append("\\n");
                    start = ++idx;
                    break;
                }
                case '\u000b': {
                    this.append(value, start, idx);
                    this.sb.append("\\v");
                    start = ++idx;
                    break;
                }
                case '\f': {
                    this.append(value, start, idx);
                    this.sb.append("\\f");
                    start = ++idx;
                    break;
                }
                case '\r': {
                    this.append(value, start, idx);
                    this.sb.append("\\r");
                    start = ++idx;
                    break;
                }
                case '\\': {
                    this.append(value, start, idx);
                    this.sb.append('\\');
                    start = idx++;
                    break;
                }
                case '\"': {
                    this.append(value, start, idx);
                    this.sb.append('\\');
                    start = idx++;
                    break;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '`': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    ++idx;
                    break;
                }
                default: {
                    int cp = value.codePointAt(idx);
                    if (this.isPrintableChar(cp)) {
                        if (cp != c) {
                            idx += 2;
                            break;
                        }
                        ++idx;
                        break;
                    }
                    this.append(value, start, idx);
                    this.appendEscapedCodepoint(cp);
                    start = cp != c ? (idx += 2) : ++idx;
                }
            }
        }
        this.append(value, start, idx);
    }

    public void appendStringD(String value) {
        this.sb.ensureCapacity(value.length() + 2);
        this.sb.append('\"');
        this.appendEscapedQuoteD(value);
        this.sb.append('\"');
    }

    private void appendEscaped(String value) {
        int idx;
        int start = idx = 0;
        while (idx < value.length()) {
            char c = value.charAt(idx);
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    this.append(value, start, idx);
                    this.appendEscapedCodepoint(c);
                    start = ++idx;
                    break;
                }
                case '\u0007': {
                    this.append(value, start, idx);
                    this.sb.append("\\a");
                    start = ++idx;
                    break;
                }
                case '\b': {
                    this.append(value, start, idx);
                    this.sb.append("\\b");
                    start = ++idx;
                    break;
                }
                case '\t': {
                    this.append(value, start, idx);
                    this.sb.append("\\t");
                    start = ++idx;
                    break;
                }
                case '\n': {
                    this.append(value, start, idx);
                    this.sb.append("\\n");
                    start = ++idx;
                    break;
                }
                case '\u000b': {
                    this.append(value, start, idx);
                    this.sb.append("\\v");
                    start = ++idx;
                    break;
                }
                case '\f': {
                    this.append(value, start, idx);
                    this.sb.append("\\f");
                    start = ++idx;
                    break;
                }
                case '\r': {
                    this.append(value, start, idx);
                    this.sb.append("\\r");
                    start = ++idx;
                    break;
                }
                case '\\': {
                    this.append(value, start, idx);
                    this.sb.append('\\');
                    start = idx++;
                    break;
                }
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '`': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    ++idx;
                    break;
                }
                default: {
                    int cp = value.codePointAt(idx);
                    if (this.isPrintableChar(cp)) {
                        if (cp != c) {
                            idx += 2;
                            break;
                        }
                        ++idx;
                        break;
                    }
                    this.append(value, start, idx);
                    this.appendEscapedCodepoint(cp);
                    start = cp != c ? (idx += 2) : ++idx;
                }
            }
        }
        this.append(value, start, idx);
    }

    private void appendEscapedG(String value) {
        int idx;
        int start = idx = 0;
        while (idx < value.length()) {
            char c = value.charAt(idx);
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    this.append(value, start, idx);
                    this.appendEscapedCodepoint(c);
                    start = ++idx;
                    break;
                }
                case '\u0007': {
                    this.append(value, start, idx);
                    this.sb.append("\\a");
                    start = ++idx;
                    break;
                }
                case '\b': {
                    this.append(value, start, idx);
                    this.sb.append("\\b");
                    start = ++idx;
                    break;
                }
                case '\t': {
                    this.append(value, start, idx);
                    this.sb.append("\\t");
                    start = ++idx;
                    break;
                }
                case '\n': {
                    this.append(value, start, idx);
                    this.sb.append("\\n");
                    start = ++idx;
                    break;
                }
                case '\u000b': {
                    this.append(value, start, idx);
                    this.sb.append("\\v");
                    start = ++idx;
                    break;
                }
                case '\f': {
                    this.append(value, start, idx);
                    this.sb.append("\\f");
                    start = ++idx;
                    break;
                }
                case '\r': {
                    this.append(value, start, idx);
                    this.sb.append("\\r");
                    start = ++idx;
                    break;
                }
                case '`': {
                    this.append(value, start, idx);
                    this.sb.append("\\`");
                    start = ++idx;
                    break;
                }
                case '\\': {
                    this.append(value, start, idx);
                    this.sb.append('\\');
                    start = idx++;
                    break;
                }
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    ++idx;
                    break;
                }
                default: {
                    int cp = value.codePointAt(idx);
                    if (this.isPrintableChar(cp)) {
                        if (cp != c) {
                            idx += 2;
                            break;
                        }
                        ++idx;
                        break;
                    }
                    this.append(value, start, idx);
                    this.appendEscapedCodepoint(cp);
                    start = cp != c ? (idx += 2) : ++idx;
                }
            }
        }
        this.append(value, start, idx);
    }

    private boolean appendEscaped(String value, boolean isEscaped, int max) {
        int idx;
        int start = idx = 0;
        int end = 0;
        while (idx < value.length() && this.sb.length() + (idx - start) < max) {
            char c = value.charAt(idx);
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    this.append(value, start, idx);
                    end = this.sb.length();
                    this.appendEscapedCodepoint(c);
                    start = ++idx;
                    break;
                }
                case '\u0007': {
                    this.append(value, start, idx);
                    end = this.sb.length();
                    this.sb.append("\\a");
                    start = ++idx;
                    break;
                }
                case '\b': {
                    this.append(value, start, idx);
                    end = this.sb.length();
                    this.sb.append("\\b");
                    start = ++idx;
                    break;
                }
                case '\t': {
                    this.append(value, start, idx);
                    end = this.sb.length();
                    this.sb.append("\\t");
                    start = ++idx;
                    break;
                }
                case '\n': {
                    this.append(value, start, idx);
                    this.sb.append("\\n");
                    end = this.sb.length();
                    start = ++idx;
                    break;
                }
                case '\u000b': {
                    this.append(value, start, idx);
                    end = this.sb.length();
                    this.sb.append("\\v");
                    start = ++idx;
                    break;
                }
                case '\f': {
                    this.append(value, start, idx);
                    end = this.sb.length();
                    this.sb.append("\\f");
                    start = ++idx;
                    break;
                }
                case '\r': {
                    this.append(value, start, idx);
                    end = this.sb.length();
                    this.sb.append("\\r");
                    start = ++idx;
                    break;
                }
                case '\\': {
                    this.append(value, start, idx);
                    end = this.sb.length();
                    this.sb.append('\\');
                    start = isEscaped ? ++idx : idx++;
                    break;
                }
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '`': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    ++idx;
                    break;
                }
                default: {
                    int cp = value.codePointAt(idx);
                    if (this.isPrintableChar(cp)) {
                        if (cp != c) {
                            idx += 2;
                            ++max;
                            break;
                        }
                        ++idx;
                        break;
                    }
                    this.append(value, start, idx);
                    end = this.sb.length();
                    this.appendEscapedCodepoint(cp);
                    start = cp != c ? (idx += 2) : ++idx;
                }
            }
        }
        if (this.sb.length() >= max) {
            this.sb.setLength(end);
            return false;
        }
        this.append(value, start, idx);
        return idx == value.length();
    }

    public String escapeString(String s) {
        int idx;
        this.sb.setLength(0);
        int start = idx = 0;
        while (idx < s.length()) {
            char c = s.charAt(idx);
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    this.append(s, start, idx);
                    this.appendEscapedCodepoint(c);
                    start = ++idx;
                    break;
                }
                case '\u0007': {
                    this.append(s, start, idx);
                    this.sb.append("\\a");
                    start = ++idx;
                    break;
                }
                case '\b': {
                    this.append(s, start, idx);
                    this.sb.append("\\b");
                    start = ++idx;
                    break;
                }
                case '\t': {
                    this.append(s, start, idx);
                    this.sb.append("\\t");
                    start = ++idx;
                    break;
                }
                case '\n': {
                    this.append(s, start, idx);
                    this.sb.append("\\n");
                    start = ++idx;
                    break;
                }
                case '\u000b': {
                    this.append(s, start, idx);
                    this.sb.append("\\v");
                    start = ++idx;
                    break;
                }
                case '\f': {
                    this.append(s, start, idx);
                    this.sb.append("\\f");
                    start = ++idx;
                    break;
                }
                case '\r': {
                    this.append(s, start, idx);
                    this.sb.append("\\r");
                    start = ++idx;
                    break;
                }
                case '\\': {
                    this.append(s, start, idx);
                    this.sb.append("\\");
                    start = idx++;
                    break;
                }
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '`': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    ++idx;
                    break;
                }
                default: {
                    int cp = s.codePointAt(idx);
                    if (this.isPrintableChar(cp)) {
                        if (cp != c) {
                            idx += 2;
                            break;
                        }
                        ++idx;
                        break;
                    }
                    this.append(s, start, idx);
                    this.appendEscapedCodepoint(cp);
                    start = cp != c ? (idx += 2) : ++idx;
                }
            }
        }
        if (start != 0) {
            this.append(s, start, idx);
            return this.sb.toString();
        }
        return s;
    }

    public void appendRaw(byte raw) {
        this.appendUIntHex2(raw);
    }

    public void append(RStore<?> data, int idx) {
        if (data.isNA(idx)) {
            this.sb.append(NA_STRING);
            return;
        }
        switch (data.getStoreType()) {
            case 2: {
                this.appendInt(data.getInt(idx));
                return;
            }
            case 3: {
                this.appendNum(data.getNum(idx));
                return;
            }
            case 5: {
                this.appendStringD(data.getChar(idx));
                return;
            }
            case 6: {
                this.appendRaw(data.getRaw(idx));
                return;
            }
            case 10: {
                this.appendName((RStore<?>)((RFactorStore)data).getLevels(), data.getInt(idx) - 1);
                return;
            }
        }
        this.sb.append(data.getChar(idx));
    }

    public void appendName(RStore<?> data, int idx) {
        if (data.isNA(idx)) {
            this.sb.append(NAME_NA_STRING);
        }
        switch (data.getStoreType()) {
            case 5: {
                this.appendEscaped(data.getChar(idx));
                return;
            }
        }
        this.sb.append(data.getChar(idx));
    }

    public void appendName(String name, boolean quote) {
        if (quote) {
            this.sb.ensureCapacity(name.length() + 2);
            this.sb.append('`');
            this.appendEscapedG(name);
            this.sb.append('`');
        } else {
            this.appendEscaped(name);
        }
    }

    public void appendSourceLine(String source, int limit) {
        if (!this.appendEscaped(source, true, limit)) {
            this.sb.append('\u2026');
        }
    }

    public String format(RStore<?> data, int idx) {
        if (data.isNA(idx)) {
            return NA_STRING;
        }
        switch (data.getStoreType()) {
            case 3: {
                return this.formatNum(data.getNum(idx));
            }
            case 5: {
                this.clear();
                this.appendStringD(data.getChar(idx));
                return this.getString();
            }
            case 6: {
                this.clear();
                this.appendUIntHex2(data.getRaw(idx));
                return this.getString();
            }
            case 10: {
                return this.formatName((RStore<?>)((RFactorStore)data).getLevels(), data.getInt(idx) - 1);
            }
        }
        return (String)ObjectUtils.nonNullAssert((Object)data.getChar(idx));
    }

    public String formatName(RStore<?> data, int idx) {
        if (data.isNA(idx)) {
            return NAME_NA_STRING;
        }
        switch (data.getStoreType()) {
            case 5: {
                return this.escapeString(data.getChar(idx));
            }
        }
        return (String)ObjectUtils.nonNullAssert((Object)data.getChar(idx));
    }

    public String quoteName(String name) {
        int idx;
        this.clear();
        this.sb.append('\"');
        int start = idx = 0;
        while (idx < name.length()) {
            if ((idx = name.indexOf(34, idx)) < 0) break;
            this.append(name, start, idx);
            this.sb.append('\\');
            start = idx++;
        }
        this.append(name, start, name.length());
        this.sb.append('\"');
        return this.getString();
    }

    public void correctNameRegions(int[] regions, String name, boolean quote, int offset) {
        if (!quote) {
            throw new UnsupportedOperationException();
        }
        this.correctRegionsEscapeG(name, regions, offset, 1, 1);
    }

    private int shiftRegions(int[] regions, int i, int endOffset, int shift) {
        while (i < regions.length && regions[i] <= endOffset) {
            int n = i++;
            regions[n] = regions[n] + shift;
        }
        return i;
    }

    private int shiftRegionsClosed(int[] regions, int i, int endOffset, int shift) {
        while (i < regions.length && (regions[i] < endOffset || i % 2 == 1 && regions[i] == endOffset)) {
            int n = i++;
            regions[n] = regions[n] + shift;
        }
        return i;
    }

    private void shiftRegionsRemaining(int[] regions, int i, int shift) {
        while (i < regions.length) {
            int n = i++;
            regions[n] = regions[n] + shift;
        }
    }

    private void correctRegionsEscapeG(String value, int[] regions, int valueOffset, int shift, int shiftAtEnd) {
        int i = 0;
        while (true) {
            if (i >= regions.length) {
                return;
            }
            if (regions[i] >= valueOffset) break;
            ++i;
        }
        int idx = 0;
        while (idx < value.length()) {
            char c = value.charAt(idx);
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    i = this.shiftRegions(regions, i, valueOffset + idx, shift);
                    if (i >= regions.length) {
                        return;
                    }
                    ++idx;
                    break;
                }
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\\': 
                case '`': {
                    i = this.shiftRegions(regions, i, valueOffset + idx, shift);
                    if (i >= regions.length) {
                        return;
                    }
                    ++shift;
                    ++idx;
                    break;
                }
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    ++idx;
                    break;
                }
                default: {
                    i = this.shiftRegions(regions, i, valueOffset + idx, shift);
                    if (i >= regions.length) {
                        return;
                    }
                    int cp = value.codePointAt(idx);
                    if (cp != c) {
                        if (!this.isPrintableChar(cp)) {
                            shift += this.getEscapedCodepointLength(cp) - 2;
                        }
                        idx += 2;
                        break;
                    }
                    if (!this.isPrintableChar(cp)) {
                        shift += this.getEscapedCodepointLength(cp) - 1;
                    }
                    ++idx;
                }
            }
        }
        i = this.shiftRegionsClosed(regions, i, valueOffset + idx, shift);
        this.shiftRegionsRemaining(regions, i, shift + shiftAtEnd);
    }
}

