/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.net.core;

import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.internal.ecommons.net.core.ESshSettings;
import org.eclipse.statet.internal.ecommons.net.core.jsch.EJSchClientSessionFactory;
import org.eclipse.statet.internal.ecommons.net.core.sshd.ESshdClientSessionFactory;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.net.core.BasicRemoteSessionService;
import org.eclipse.statet.jcommons.net.core.RemoteClientSessionFactory;
import org.eclipse.statet.jcommons.net.core.RemoteSessionService;
import org.eclipse.statet.jcommons.status.StatusException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@NonNullByDefault
public final class ECommonsNetCorePlugin
extends Plugin {
    private static ECommonsNetCorePlugin instance;
    private boolean started;
    private final CopyOnWriteArraySet<Disposable> disposables = new CopyOnWriteArraySet();
    private @Nullable BasicRemoteSessionService sshService;

    public static ECommonsNetCorePlugin getInstance() {
        return instance;
    }

    public ECommonsNetCorePlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            ECommonsNetCorePlugin eCommonsNetCorePlugin = this;
            synchronized (eCommonsNetCorePlugin) {
                this.started = false;
                this.sshService = null;
            }
            try {
                for (Disposable listener : this.disposables) {
                    listener.dispose();
                }
            }
            finally {
                this.disposables.clear();
            }
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    public void addStopListener(Disposable listener) {
        this.disposables.add(listener);
    }

    public void removeStopListener(Disposable listener) {
        this.disposables.remove(listener);
    }

    private @Nullable IProxyService getProxyService() {
        BundleContext context = this.getBundle().getBundleContext();
        ServiceReference reference = context.getServiceReference(IProxyService.class);
        if (reference == null) {
            return null;
        }
        return (IProxyService)context.getService(reference);
    }

    public synchronized RemoteSessionService getRemoteSessionManager() throws StatusException {
        BasicRemoteSessionService service = this.sshService;
        if (service == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            String implId = System.getProperty("org.eclipse.statet.jcommons.net.core.ssh.Service");
            if (implId != null && implId.equals("jsch-0")) {
                service = new BasicRemoteSessionService((RemoteClientSessionFactory)new EJSchClientSessionFactory());
            } else {
                ESshSettings sshSettings = new ESshSettings(EPreferences.getInstancePrefs());
                service = new BasicRemoteSessionService((RemoteClientSessionFactory)new ESshdClientSessionFactory(sshSettings, this.getProxyService()));
            }
            this.addStopListener((Disposable)service);
            this.sshService = service;
        }
        return service;
    }
}

