/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.rj.servi.jmx.NodeStateMX;
import org.eclipse.statet.rj.servi.pool.PoolNodeItem;
import org.eclipse.statet.rj.servi.pool.PoolNodeState;

@NonNullByDefault
public class MXNodeState
implements NodeStateMX {
    private final PoolNodeItem item;
    private final Instant creationTime;
    private final Instant stateTime;

    public MXNodeState(PoolNodeItem item) {
        this.item = item;
        this.creationTime = this.item.getCreationTime();
        this.stateTime = this.item.getStateTime();
    }

    @Override
    public PoolNodeState getState() {
        return this.item.getState();
    }

    @Override
    public Date getStateBeginTime() {
        return Date.from(this.stateTime);
    }

    @Override
    public @Nullable String getCurrentClientLabel() {
        return this.item.getCurrentClientLabel();
    }

    @Override
    public Date getCreationTime() {
        return Date.from(this.creationTime);
    }

    @Override
    public long getUsageCount() {
        return this.item.getUsageCount();
    }

    @Override
    public long getUsageDurationMillis() {
        Duration duration = this.item.getUsageDuration();
        return duration != null ? duration.toMillis() : -1L;
    }

    @Override
    public @Nullable String getRMIAddress() {
        RMIAddress address = this.item.getAddress();
        return address != null ? address.getAddress() : null;
    }
}

