/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.BasicEditorOutlinePage;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.dataeditor.ContentDescription;
import org.eclipse.statet.internal.r.ui.dataeditor.FTableVariable;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataEditor;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataLabelProvider;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.ui.dataeditor.DataViewDescription;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.r.ui.dataeditor.RDataTableContentDescription;
import org.eclipse.statet.r.ui.dataeditor.RDataTableInput;
import org.eclipse.statet.r.ui.dataeditor.RDataTableListener;
import org.eclipse.statet.r.ui.dataeditor.RDataTableVariable;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;

@NonNullByDefault
public class RDataEditorOutlinePage
extends BasicEditorOutlinePage
implements IShowInTarget {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final RDataEditor editor;
    private @Nullable ContentDescription contentDescription;

    public RDataEditorOutlinePage(RDataEditor editor) {
        super("org.eclipse.statet.r.menu.RDataOutlineViewContextMenu");
        this.editor = editor;
    }

    public RDataEditor getDataEditor() {
        return this.editor;
    }

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((Plugin)RUIPlugin.getInstance(), (String)"RDataOutlineView");
    }

    protected void configureViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)new RDataContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new RDataLabelProvider());
        viewer.setInput((Object)this);
    }

    protected void init() {
        super.init();
        this.editor.getRDataTable().addTableListener(new RDataTableListener(){

            @Override
            public void onInputChanged(RDataTableInput input, RDataTableContentDescription description, DataViewDescription dataViewDescription) {
                ContentDescription oldDescription = RDataEditorOutlinePage.this.contentDescription;
                ContentDescription newDescription = (ContentDescription)description;
                boolean isNew = newDescription != null && (oldDescription == null || oldDescription.getVariables().length != newDescription.getVariables().length);
                RDataEditorOutlinePage.this.contentDescription = newDescription;
                TreeViewer viewer = RDataEditorOutlinePage.this.getViewer();
                if (viewer == null || !UIAccess.isOkToUse((Control)viewer.getControl())) {
                    return;
                }
                viewer.refresh();
                if (isNew && RDataEditorOutlinePage.this.contentDescription != null) {
                    viewer.expandToLevel(3);
                }
            }
        });
    }

    protected @Nullable TreeViewer getViewer() {
        return (TreeViewer)super.getViewer();
    }

    protected void selectInEditor(ISelection selection) {
        Object element;
        IStructuredSelection structuredSelection;
        if (selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (element = structuredSelection.getFirstElement()) instanceof RDataTableColumn) {
            this.editor.getRDataTable().revealColumn(((RDataTableColumn)element).getIndex());
        }
    }

    protected void contextMenuAboutToShow(IMenuManager m) {
        IStructuredSelection selection = (IStructuredSelection)((TreeViewer)ObjectUtils.nonNullAssert((Object)this.getViewer())).getSelection();
        for (Object element : selection) {
            if (element instanceof RDataTableColumn) continue;
            return;
        }
        m.add((IContributionItem)new SimpleContributionItem("Select Column", "S"){

            protected void execute() throws ExecutionException {
                TreeViewer viewer = RDataEditorOutlinePage.this.getViewer();
                if (viewer == null || !UIAccess.isOkToUse((Control)viewer.getControl())) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                LRangeList columnIndexes = new LRangeList();
                for (Object element : selection) {
                    if (element instanceof RDataTableColumn) {
                        columnIndexes.values().add(((RDataTableColumn)element).getIndex());
                        continue;
                    }
                    return;
                }
                RDataEditorOutlinePage.this.editor.getRDataTable().selectColumns((Collection<LRange>)columnIndexes);
            }
        });
        m.add((IContributionItem)new Separator());
        if (selection.size() == 1) {
            m.add((IContributionItem)new SimpleContributionItem("Sort Increasing by Column", "I", SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctool/sort.alpha"), null){

                protected void execute() throws ExecutionException {
                    TreeViewer viewer = RDataEditorOutlinePage.this.getViewer();
                    if (viewer == null || !UIAccess.isOkToUse((Control)viewer.getControl())) {
                        return;
                    }
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    Object element = selection.getFirstElement();
                    if (selection.size() == 1 && element instanceof RDataTableColumn) {
                        RDataTableColumn column = (RDataTableColumn)element;
                        RDataEditorOutlinePage.this.editor.getRDataTable().sortByColumn(column.getIndex(), true);
                    }
                }
            });
            m.add((IContributionItem)new SimpleContributionItem("Sort Decreasing by Column", "I"){

                protected void execute() throws ExecutionException {
                    TreeViewer viewer = RDataEditorOutlinePage.this.getViewer();
                    if (viewer == null || !UIAccess.isOkToUse((Control)viewer.getControl())) {
                        return;
                    }
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    Object element = selection.getFirstElement();
                    if (selection.size() == 1 && element instanceof RDataTableColumn) {
                        RDataTableColumn column = (RDataTableColumn)element;
                        RDataEditorOutlinePage.this.editor.getRDataTable().sortByColumn(column.getIndex(), false);
                    }
                }
            });
        }
        m.add((IContributionItem)new SimpleContributionItem("Clear All Sorting", "O"){

            protected void execute() throws ExecutionException {
                RDataEditorOutlinePage.this.editor.getRDataTable().clearSorting();
            }
        });
    }

    public boolean show(ShowInContext context) {
        return this.editor.getEditorInput() == context.getInput();
    }

    private static class FTableFactorLevels
    extends VariablePropertyItem {
        public FTableFactorLevels(FTableVariable variable) {
            super(variable);
        }

        @Override
        public boolean hasChildren() {
            return true;
        }

        @Override
        public Object[] getChildren() {
            RStore data = ((FTableVariable)this.variable).getLevelStore();
            return data.toArray();
        }

        @Override
        public String getName() {
            return "Levels";
        }

        @Override
        public int getCount() {
            RStore data = ((FTableVariable)this.variable).getLevelStore();
            return (int)data.getLength();
        }
    }

    private static class FactorLevels
    extends VariablePropertyItem {
        public FactorLevels(RDataTableColumn column) {
            super(column);
        }

        @Override
        public boolean hasChildren() {
            return true;
        }

        @Override
        public Object[] getChildren() {
            RFactorStore data = (RFactorStore)((RDataTableColumn)this.variable).getDataStore();
            return data.getLevels().toArray();
        }

        @Override
        public String getName() {
            return "Factor Levels";
        }

        @Override
        public int getCount() {
            RFactorStore data = (RFactorStore)((RDataTableColumn)this.variable).getDataStore();
            return data.getLevelCount();
        }
    }

    private class RDataContentProvider
    implements ITreeContentProvider {
        private RDataContentProvider() {
        }

        public void inputChanged(Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ContentDescription contentDescription = RDataEditorOutlinePage.this.contentDescription;
            if (contentDescription != null) {
                return new Object[]{contentDescription};
            }
            return NO_CHILDREN;
        }

        public @Nullable Object getParent(Object element) {
            if (element instanceof RDataTableColumn) {
                return RDataEditorOutlinePage.this.contentDescription;
            }
            if (element instanceof VariablePropertyItem) {
                return ((VariablePropertyItem)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            ContentDescription contentDescription = RDataEditorOutlinePage.this.contentDescription;
            if (element == contentDescription) {
                return contentDescription.getVariables().length > 0;
            }
            if (element instanceof RDataTableColumn) {
                RDataTableColumn column = (RDataTableColumn)element;
                return column.getVarType() == 10;
            }
            if (element instanceof FTableVariable) {
                return true;
            }
            if (element instanceof VariablePropertyItem) {
                VariablePropertyItem item = (VariablePropertyItem)element;
                return item.hasChildren();
            }
            return false;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] columns;
            ContentDescription contentDescription = RDataEditorOutlinePage.this.contentDescription;
            if (parentElement == contentDescription && (columns = contentDescription.getVariables()).length <= 2500) {
                return columns;
            }
            if (parentElement instanceof RDataTableColumn) {
                RDataTableColumn column = (RDataTableColumn)parentElement;
                if (column.getVarType() == 10) {
                    return new Object[]{new FactorLevels(column)};
                }
            } else {
                if (parentElement instanceof FTableVariable) {
                    return new Object[]{new FTableFactorLevels((FTableVariable)parentElement)};
                }
                if (parentElement instanceof VariablePropertyItem) {
                    VariablePropertyItem item = (VariablePropertyItem)parentElement;
                    return item.getChildren();
                }
            }
            return new Object[0];
        }

        public void dispose() {
        }
    }

    static abstract class VariablePropertyItem {
        protected final RDataTableVariable variable;

        public VariablePropertyItem(RDataTableVariable column) {
            this.variable = column;
        }

        public Object getParent() {
            return this.variable;
        }

        public boolean hasChildren() {
            return false;
        }

        public Object[] getChildren() {
            return NO_CHILDREN;
        }

        public abstract String getName();

        public int getCount() {
            return -1;
        }

        public int hashCode() {
            return this.getName().hashCode() * this.variable.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof VariablePropertyItem) {
                VariablePropertyItem other = (VariablePropertyItem)obj;
                return this.getName() == other.getName() && this.variable.equals(other.variable);
            }
            return false;
        }
    }
}

