/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.util;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String build;
    private transient @Nullable String versionString;
    private transient int hash;

    private static int parseInt(String value, String componentName) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.valueOf(componentName) + "= '" + value + "'", e);
        }
    }

    private static void validateInt(int value, String componentName) {
        if (value < 0) {
            throw new IllegalArgumentException(String.valueOf(componentName) + "= " + value);
        }
    }

    public Version(int major, int minor, int micro, @Nullable String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.build = ObjectUtils.nonNullElse(qualifier, "");
        this.validate();
    }

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public Version(String version) {
        int major = 0;
        int minor = 0;
        int micro = 0;
        String build = "";
        String[] components = version.split("\\.", 4);
        if (components.length == 0 || components[0].isEmpty()) {
            throw new IllegalArgumentException("version= '" + version + "'");
        }
        major = Version.parseInt(components[0], "major");
        if (components.length >= 2) {
            minor = Version.parseInt(components[1], "minor");
            if (components.length >= 3) {
                micro = Version.parseInt(components[2], "micro");
                if (components.length >= 4) {
                    build = components[3];
                }
            }
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.build = build;
        this.validate();
    }

    private void validate() {
        Version.validateInt(this.major, "major");
        Version.validateInt(this.minor, "minor");
        Version.validateInt(this.micro, "micro");
        int i = 0;
        while (i < this.build.length()) {
            char c = this.build.charAt(i);
            if (!Character.isDefined(c) || c == ' ') {
                throw new IllegalArgumentException("build= " + this.build);
            }
            ++i;
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getBuild() {
        return this.build;
    }

    public int hashCode() {
        int h = this.hash;
        if (h != 0) {
            return h;
        }
        h = 527;
        h = 31 * h + this.major;
        h = 31 * h + this.minor;
        h = 31 * h + this.micro;
        this.hash = h = 31 * h + this.build.hashCode();
        return this.hash;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Version) {
            Version other = (Version)object;
            return this.major == other.major && this.minor == other.minor && this.micro == other.micro && this.build.equals(other.build);
        }
        return false;
    }

    @Override
    public int compareTo(Version other) {
        if (this == other) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0) {
            return result;
        }
        return this.build.compareTo(other.build);
    }

    public String toString() {
        String s = this.versionString;
        if (s != null) {
            return s;
        }
        StringBuilder sb = new StringBuilder(20 + this.build.length());
        sb.append(this.major);
        sb.append('.');
        sb.append(this.minor);
        sb.append('.');
        sb.append(this.micro);
        if (!this.build.isEmpty()) {
            sb.append('.');
            sb.append(this.build);
        }
        this.versionString = sb.toString();
        return this.versionString;
    }
}

