/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.servi.pool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.servi.pool.PoolNodeItem;
import org.eclipse.statet.rj.servi.pool.PoolNodeObject;
import org.eclipse.statet.rj.servi.pool.PoolServer;
import org.eclipse.statet.rj.servi.pool.RServiPoolManager;

@NonNullByDefault
public abstract class PoolStatus<N> {
    private final RServiPoolManager.Counter NO_MANAGER = new RServiPoolManager.Counter();
    protected final PoolServer server;
    private long stamp;
    private RServiPoolManager.Counter counter = (RServiPoolManager.Counter)ObjectUtils.nonNullLateInit();
    private List<N> nodeStates = (List)ObjectUtils.nonNullLateInit();

    public PoolStatus(PoolServer server) {
        this.server = (PoolServer)ObjectUtils.nonNullAssert((Object)server);
    }

    protected long getStatusStamp() {
        return this.stamp;
    }

    public synchronized int getNumInUse() {
        this.check();
        return this.counter.numInUse;
    }

    public synchronized int getNumIdling() {
        this.check();
        return this.counter.numIdling;
    }

    public synchronized int getNumTotal() {
        this.check();
        return this.counter.numTotal;
    }

    public synchronized int getMaxInUse() {
        this.check();
        return this.counter.maxInUse;
    }

    public synchronized int getMaxIdling() {
        this.check();
        return this.counter.maxIdling;
    }

    public synchronized int getMaxTotal() {
        this.check();
        return this.counter.maxTotal;
    }

    public synchronized List<N> getNodeStates() {
        this.check();
        return this.nodeStates;
    }

    protected void check() {
    }

    protected void refresh(@Nullable RServiPoolManager manager, long stamp) {
        List list;
        RServiPoolManager.Counter counter;
        if (manager == null) {
            counter = this.NO_MANAGER;
            list = Collections.emptyList();
        } else {
            Collection<? extends PoolNodeObject> objects = manager.getPoolNodeObjects();
            counter = manager.getCounter();
            list = new ArrayList();
            counter.numIdling = 0;
            counter.numInUse = 0;
            counter.numTotal = 0;
            for (PoolNodeObject poolNodeObject : objects) {
                PoolNodeItem item = this.createPoolItem(poolNodeObject, stamp);
                N nodeState = this.createNodeState(item);
                switch (item.getState()) {
                    case ALLOCATED: {
                        ++counter.numInUse;
                        break;
                    }
                    case IDLING: {
                        ++counter.numIdling;
                        break;
                    }
                }
                ++counter.numTotal;
                list.add(nodeState);
            }
        }
        this.stamp = stamp;
        this.counter = counter;
        this.nodeStates = list;
    }

    protected PoolNodeItem createPoolItem(PoolNodeObject node, long stamp) {
        return new PoolNodeItem(node, stamp);
    }

    protected abstract N createNodeState(PoolNodeItem var1);
}

