/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.docmlet.wikitext.core.WikitextBuildParticipant;
import org.eclipse.statet.internal.docmlet.wikitext.core.WikitextProjectNature;
import org.eclipse.statet.internal.docmlet.wikitext.core.builder.WikitextProjectBuilder;
import org.eclipse.statet.ltk.model.core.LtkModels;

public abstract class WikitextProjectTask {
    private static final WikitextBuildParticipant NO_PARTICIPANT = new WikitextBuildParticipant();
    private final Map<String, WikitextBuildParticipant> participants = new HashMap<String, WikitextBuildParticipant>();
    private final WikitextProjectBuilder wikitextProjectBuilder;
    private final WikitextProjectNature wikitextProject;
    private int buildType;

    public WikitextProjectTask(WikitextProjectBuilder projectBuilder) {
        this.wikitextProjectBuilder = projectBuilder;
        this.wikitextProject = projectBuilder.getWikitextProject();
    }

    protected final WikitextProjectBuilder getWikitextProjectBuilder() {
        return this.wikitextProjectBuilder;
    }

    public final WikitextProjectNature getWikitextProject() {
        return this.wikitextProject;
    }

    public void setBuildType(int buildType) {
        this.buildType = buildType;
    }

    protected final Collection<WikitextBuildParticipant> getParticipants() {
        Collection<WikitextBuildParticipant> values = this.participants.values();
        ArrayList<WikitextBuildParticipant> list = new ArrayList<WikitextBuildParticipant>(values.size());
        for (WikitextBuildParticipant participant : values) {
            if (participant == null) continue;
            list.add(participant);
        }
        return list;
    }

    protected final WikitextBuildParticipant getParticipant(String modelTypeId) {
        if (modelTypeId == null) {
            return null;
        }
        WikitextBuildParticipant participant = this.participants.get(modelTypeId);
        if (participant == null) {
            participant = this.loadParticipant(modelTypeId);
            this.participants.put(modelTypeId, participant);
        }
        return participant != NO_PARTICIPANT ? participant : null;
    }

    private WikitextBuildParticipant loadParticipant(String modelTypeId) {
        WikitextBuildParticipant participant = (WikitextBuildParticipant)LtkModels.getModelAdapter((String)modelTypeId, WikitextBuildParticipant.class);
        if (participant == null) {
            return NO_PARTICIPANT;
        }
        participant.wikitextProject = this.getWikitextProject();
        participant.buildType = this.buildType;
        participant.enabled = false;
        participant.init();
        return participant;
    }
}

