/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.util;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchPart;

@NonNullByDefault
public class LTKSelectionUtils {
    public static TextRegion toTextRegion(ITextSelection selection) {
        return JFaceTextRegion.newByStartLength((int)selection.getOffset(), (int)selection.getLength());
    }

    public static TextRegion toTextRegion(Point selectedRange) {
        return JFaceTextRegion.newByStartLength((int)selectedRange.x, (int)selectedRange.y);
    }

    public static TextRegion toTextRegion(IRegion region) {
        return JFaceTextRegion.toTextRegion((IRegion)region);
    }

    public static TextRegion toTextRegion(Position position) {
        return JFaceTextRegion.newByStartLength((int)position.getOffset(), (int)position.getLength());
    }

    public static LtkModelElement @Nullable [] getSelectedElements(@Nullable ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return LTKSelectionUtils.getSelectedElements((IStructuredSelection)selection);
        }
        return null;
    }

    public static LtkModelElement @Nullable [] getSelectedElements(IStructuredSelection selection) {
        LtkModelElement[] elements = new LtkModelElement[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (i < elements.length) {
            Object next = iter.next();
            if (!(next instanceof LtkModelElement)) {
                return null;
            }
            elements[i] = (LtkModelElement)next;
            ++i;
        }
        return elements;
    }

    public static @Nullable SourceUnit getSingleSourceUnit(IWorkbenchPart part) {
        ISourceEditor editor = (ISourceEditor)part.getAdapter(ISourceEditor.class);
        if (editor == null) {
            return null;
        }
        return editor.getSourceUnit();
    }

    public static @Nullable AstNode getSelectedAstNode(SourceUnit su, String type, @Nullable ISelection selection, IProgressMonitor monitor) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            SourceUnitModelInfo modelInfo = su.getModelInfo(type, 2, monitor);
            if (modelInfo == null) {
                return null;
            }
            AstInfo info = modelInfo.getAst();
            if (info == null || info.getRoot() == null) {
                return null;
            }
            AstSelection astSelection = AstSelection.search((AstNode)info.getRoot(), (int)textSelection.getOffset(), (int)(textSelection.getOffset() + textSelection.getLength()), (int)3);
            return astSelection.getCovering();
        }
        return null;
    }

    public static SourceStructElement @Nullable [] getSelectedSourceStructElements(@Nullable ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return LTKSelectionUtils.getSelectedSourceStructElements((IStructuredSelection)selection);
        }
        return null;
    }

    public static SourceStructElement @Nullable [] getSelectedSourceStructElements(IStructuredSelection selection) {
        SourceStructElement[] elements = new SourceStructElement[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (i < elements.length) {
            Object next = iter.next();
            if (!(next instanceof SourceStructElement)) {
                return null;
            }
            elements[i] = (SourceStructElement)next;
            ++i;
        }
        return elements;
    }

    public static IFile @Nullable [] getSelectedFiles(@Nullable ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return LTKSelectionUtils.getSelectedFiles((IStructuredSelection)selection);
        }
        return null;
    }

    public static IFile @Nullable [] getSelectedFiles(IStructuredSelection selection) {
        IFile[] elements = new IFile[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (i < elements.length) {
            block4: {
                block5: {
                    Object next;
                    block3: {
                        next = iter.next();
                        if (!(next instanceof IFile)) break block3;
                        elements[i] = (IFile)next;
                        break block4;
                    }
                    if (!(next instanceof IAdaptable)) break block5;
                    elements[i] = (IFile)((IAdaptable)next).getAdapter(IFile.class);
                    if (elements[i] != null) break block4;
                }
                return null;
            }
            ++i;
        }
        return elements;
    }

    public static SourceStructElement @Nullable [] getSelectedSourceStructElement(@Nullable SourceUnitModelInfo suModel, ITextSelection selection) {
        if (suModel != null) {
            SourceStructElement root = suModel.getSourceElement();
            int selectionStart = selection.getOffset();
            int selectionEnd = selectionStart + selection.getLength();
            if (selectionStart >= root.getSourceRange().getStartOffset() && selectionEnd <= root.getSourceRange().getEndOffset()) {
                return new SourceStructElement[]{LtkModelUtils.getCoveringSourceElement((SourceStructElement)root, (int)selectionStart, (int)selectionEnd)};
            }
        }
        return null;
    }
}

