/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.freeze;

import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeLayer;
import org.eclipse.statet.ecommons.waltable.layer.event.ILayerEventHandler;
import org.eclipse.statet.ecommons.waltable.layer.event.IStructuralChangeEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.StructuralDiff;

public class FreezeEventHandler
implements ILayerEventHandler<IStructuralChangeEvent> {
    private final FreezeLayer freezeLayer;

    public FreezeEventHandler(FreezeLayer freezeLayer) {
        this.freezeLayer = freezeLayer;
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        Collection<StructuralDiff> rowDiffs;
        PositionCoordinate topLeftPosition = this.freezeLayer.getTopLeftPosition();
        PositionCoordinate bottomRightPosition = this.freezeLayer.getBottomRightPosition();
        Collection<StructuralDiff> columnDiffs = event.getColumnDiffs();
        if (columnDiffs != null) {
            int leftOffset = 0;
            int rightOffset = 0;
            int freezeMove = 0;
            block8: for (StructuralDiff diff : columnDiffs) {
                long start = diff.getBeforePositionRange().start;
                switch (diff.getDiffType()) {
                    case ADD: {
                        if (start < topLeftPosition.columnPosition) {
                            leftOffset = (int)((long)leftOffset + diff.getAfterPositionRange().size());
                        }
                        if (start > bottomRightPosition.columnPosition && (freezeMove != 1 || start != bottomRightPosition.columnPosition + 1L)) continue block8;
                        rightOffset = (int)((long)rightOffset + diff.getAfterPositionRange().size());
                        break;
                    }
                    case DELETE: {
                        if (start < topLeftPosition.columnPosition) {
                            leftOffset = (int)((long)leftOffset - (Math.min(diff.getBeforePositionRange().end, topLeftPosition.columnPosition + 1L) - start));
                        }
                        if (start <= bottomRightPosition.columnPosition) {
                            rightOffset = (int)((long)rightOffset - (Math.min(diff.getBeforePositionRange().end, bottomRightPosition.columnPosition + 1L) - start));
                            if (freezeMove != 0) break;
                            freezeMove = 1;
                            break;
                        }
                        freezeMove = -1;
                        break;
                    }
                }
            }
            topLeftPosition.columnPosition += (long)leftOffset;
            bottomRightPosition.columnPosition += (long)rightOffset;
        }
        if ((rowDiffs = event.getRowDiffs()) != null) {
            int leftOffset = 0;
            int rightOffset = 0;
            int freezeMove = 0;
            block9: for (StructuralDiff diff : rowDiffs) {
                long start = diff.getBeforePositionRange().start;
                switch (diff.getDiffType()) {
                    case ADD: {
                        if (start < topLeftPosition.rowPosition) {
                            leftOffset = (int)((long)leftOffset + diff.getAfterPositionRange().size());
                        }
                        if (start > bottomRightPosition.rowPosition && (freezeMove != 1 || start != bottomRightPosition.rowPosition + 1L)) continue block9;
                        rightOffset = (int)((long)rightOffset + diff.getAfterPositionRange().size());
                        break;
                    }
                    case DELETE: {
                        if (start < topLeftPosition.rowPosition) {
                            leftOffset = (int)((long)leftOffset - (Math.min(diff.getBeforePositionRange().end, topLeftPosition.rowPosition + 1L) - start));
                        }
                        if (start <= bottomRightPosition.rowPosition) {
                            rightOffset = (int)((long)rightOffset - (Math.min(diff.getBeforePositionRange().end, bottomRightPosition.rowPosition + 1L) - start));
                            if (freezeMove != 0) break;
                            freezeMove = 1;
                            break;
                        }
                        freezeMove = -1;
                        break;
                    }
                }
            }
            topLeftPosition.rowPosition += (long)leftOffset;
            bottomRightPosition.rowPosition += (long)rightOffset;
        }
    }
}

