/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.command;

import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.command.LayerCommandUtil;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;

public abstract class AbstractPositionCommand
implements ILayerCommand {
    private PositionCoordinate positionCoordinate;

    protected AbstractPositionCommand(ILayer layer, long columnPosition, long rowPosition) {
        this.positionCoordinate = new PositionCoordinate(layer, columnPosition, rowPosition);
    }

    protected AbstractPositionCommand(AbstractPositionCommand command) {
        this.positionCoordinate = command.positionCoordinate;
    }

    public long getColumnPosition() {
        return this.positionCoordinate.getColumnPosition();
    }

    public long getRowPosition() {
        return this.positionCoordinate.getRowPosition();
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        PositionCoordinate targetPositionCoordinate = LayerCommandUtil.convertPositionToTargetContext(this.positionCoordinate, targetLayer);
        if (targetPositionCoordinate != null) {
            this.positionCoordinate = targetPositionCoordinate;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " columnPosition=" + this.positionCoordinate.getColumnPosition() + ", rowPosition=" + this.positionCoordinate.getRowPosition();
    }
}

