/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.variables.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class VariableText {
    private static final String[] LOCATION_VARIABLES = new String[]{"resource_loc", "selected_resource_loc", "container_loc", "project_loc"};
    private String fText;
    private int fState;
    private final List<String> fSpecialVariablesNames;
    private List<IDynamicVariable> fSpecialVariables;
    private final Set<String> fUnresolvedSpecial = new HashSet<String>();
    private final Map<String, String> fLocationVariables = new HashMap<String, String>();

    private static boolean isEscaped(String text, int offset) {
        int count = 1;
        while (offset >= count) {
            char c = text.charAt(offset - count);
            if (c != '$') break;
            ++count;
        }
        return count % 2 == 0;
    }

    private static void searchSurrounding(String text, int[] region) {
        while (region[0] != 0) {
            char c1 = text.charAt(region[0] - 1);
            if (c1 != ':') {
                return;
            }
            int start = text.lastIndexOf("${", region[0] - 1);
            if (start < 0 || text.lastIndexOf("}", region[0] - 1) > start || VariableText.isEscaped(text, start)) {
                return;
            }
            region[0] = start;
            int end = text.indexOf(125, region[1]);
            if (end < 0) continue;
            region[1] = end + 1;
        }
        return;
    }

    public VariableText(String text, List<String> specialVariablesNames) {
        this.fSpecialVariablesNames = specialVariablesNames;
        this.fText = text;
        this.fState = 1;
    }

    public VariableText(String text, List<IDynamicVariable> checkedVariables, boolean useDirectly) {
        ArrayList<String> specialVariablesNames = new ArrayList<String>(checkedVariables.size());
        for (IStringVariable iStringVariable : checkedVariables) {
            specialVariablesNames.add(iStringVariable.getName());
        }
        this.fSpecialVariablesNames = specialVariablesNames;
        if (useDirectly) {
            this.fSpecialVariables = checkedVariables;
        }
        this.fText = text;
        this.fState = 1;
    }

    public String getText() {
        return this.fText;
    }

    public void performInitialStringSubstitution(boolean reportUndefinedVariables) throws CoreException {
        if (this.fState != 1) {
            throw new IllegalStateException();
        }
        String text = this.fText;
        LinkedHashMap<String, String> specialVariables = new LinkedHashMap<String, String>();
        for (String variableName : this.fSpecialVariablesNames) {
            String pattern = "${" + variableName;
            int offset = -1;
            while ((offset = text.indexOf(pattern, offset + 1)) >= 0) {
                int length;
                if (VariableText.isEscaped(text, offset)) continue;
                switch (offset + pattern.length() < text.length() ? (int)text.charAt(offset + pattern.length()) : 0) {
                    case 125: {
                        length = pattern.length() + 1;
                        break;
                    }
                    case 58: {
                        length = text.indexOf(125, offset + pattern.length()) - offset + 1;
                        if (length > 0) break;
                    }
                    default: {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", NLS.bind((String)"Malformed variable expression: variable ''{0}'' not closed.", (Object)variableName)));
                    }
                }
                this.fUnresolvedSpecial.add(variableName);
                int[] region = new int[]{offset, offset + length};
                VariableText.searchSurrounding(text, region);
                String key = "XX-SPECIALVAR-" + specialVariables.size() + "-XX";
                specialVariables.put(key, new String(text.substring(region[0], region[1])));
                text = String.valueOf(text.substring(0, region[0])) + key + text.substring(region[1], text.length());
            }
        }
        text = this.searchResourceVar(text, reportUndefinedVariables);
        text = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(text, reportUndefinedVariables);
        Map.Entry[] entries = specialVariables.entrySet().toArray(new Map.Entry[specialVariables.size()]);
        int i = entries.length - 1;
        while (i >= 0) {
            text = text.replace((CharSequence)entries[i].getKey(), (CharSequence)entries[i].getValue());
            --i;
        }
        this.fText = text;
        if (this.fSpecialVariables != null) {
            for (IDynamicVariable variable : this.fSpecialVariables) {
                if (!this.require(variable.getName())) continue;
                this.set(variable);
            }
        }
        this.fState = 2;
    }

    private String searchResourceVar(String text, boolean reportUndefinedVariables) throws CoreException {
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        String[] stringArray = LOCATION_VARIABLES;
        int n = LOCATION_VARIABLES.length;
        int n2 = 0;
        while (n2 < n) {
            String variableName = stringArray[n2];
            String pattern = "${" + variableName;
            int offset = -1;
            while ((offset = text.indexOf(pattern, offset + 1)) >= 0) {
                if (VariableText.isEscaped(text, offset)) continue;
                int end = text.indexOf(125, offset);
                int next = offset + 1;
                while ((next = text.indexOf(123, next + 1)) >= 0 && next < end) {
                    end = text.indexOf(125, end + 1);
                }
                String key = "XX-RESOURCEVAR-" + this.fLocationVariables.size() + "-XX";
                this.fLocationVariables.put(key, new String(variableManager.performStringSubstitution(text.substring(offset, end + 1), reportUndefinedVariables)));
                text = String.valueOf(text.substring(0, offset)) + key + text.substring(end + 1, text.length());
            }
            ++n2;
        }
        return text;
    }

    public boolean require(String variableName) {
        return this.fUnresolvedSpecial.contains(variableName);
    }

    public void set(String variableName, String value) {
        if (this.fUnresolvedSpecial.remove(variableName)) {
            String pattern = "${" + variableName + "}";
            String text = this.fText;
            int offset = -1;
            while ((offset = text.indexOf(pattern, offset + 1)) >= 0) {
                if (VariableText.isEscaped(text, offset)) continue;
                text = String.valueOf(text.substring(0, offset)) + value + text.substring(offset + pattern.length(), text.length());
            }
            this.fText = text;
        }
    }

    public void set(IDynamicVariable variable) throws CoreException {
        if (this.fUnresolvedSpecial.remove(variable.getName())) {
            String pattern = "${" + variable.getName();
            String text = this.fText;
            int offset = -1;
            while ((offset = text.indexOf(pattern, offset + 1)) >= 0) {
                String value;
                int length;
                if (VariableText.isEscaped(text, offset)) continue;
                switch (text.charAt(offset + pattern.length())) {
                    case '}': {
                        length = pattern.length() + 1;
                        value = variable.getValue(null);
                        break;
                    }
                    case ':': {
                        if (!variable.supportsArgument()) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", NLS.bind((String)"Malformed variable expression: variable ''{0}'' doesn't support arguments.", (Object)variable.getName())));
                        }
                        length = text.indexOf(125, offset + pattern.length()) - offset + 1;
                        value = variable.getValue(text.substring(offset + pattern.length() + 1, offset + length - 1));
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                text = String.valueOf(text.substring(0, offset)) + value + text.substring(offset + length, text.length());
            }
            this.fText = text;
        }
    }

    public void performFinalStringSubstitution(LocationProcessor locationProcessor) throws CoreException {
        if (!this.fUnresolvedSpecial.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", "Unresolved variable(s): " + this.fUnresolvedSpecial.toString() + "."));
        }
        if (this.fState == 1) {
            this.performInitialStringSubstitution(true);
        }
        if (this.fState != 2) {
            throw new IllegalStateException();
        }
        String text = this.fText;
        text = this.searchResourceVar(text, true);
        text = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(text, true);
        for (Map.Entry<String, String> entry : this.fLocationVariables.entrySet()) {
            String value = locationProcessor != null ? locationProcessor.process(entry.getValue()) : entry.getValue();
            text = text.replace(entry.getKey(), value);
        }
        this.fText = text;
        this.fState = 3;
    }

    public static interface LocationProcessor {
        public String process(String var1) throws CoreException;
    }
}

