/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class ContentAssist
extends ContentAssistant {
    private static final int ON = 1;
    private static final int AUTO_REQUEST = 8;
    private static final int SPECIFIC_SESSION = 32;
    private static final int RELOAD_REQUEST = 64;
    private boolean isAutoInsertEnabled;
    private boolean isAutoInsertOverwritten;
    private boolean isRepeatedInvocationModeEnabled;
    private int completionProposalSessionRequest;
    private int completionProposalSession;
    private int completionProposalSessionCounter;
    private String specificCategoryId;
    private @Nullable ICompletionProposal completionProposalSelection;
    private int completionProposalSelectionCounter;
    private @Nullable KeySequence completionProposalKeyBinding;
    private @Nullable String completionProposalIterationGesture;
    private int contextInformationSession;
    private boolean showSubstringMatchesEnabled;

    public ContentAssist() {
        this.addCompletionListener(new SelfListener());
    }

    boolean isProposalPopupActive1() {
        return super.isProposalPopupActive();
    }

    boolean isContextInfoPopupActive1() {
        return super.isContextInfoPopupActive();
    }

    public void hidePopups() {
        this.hide();
    }

    protected void hide() {
        try {
            super.hide();
        }
        catch (RuntimeException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", "An error occurred when hiding content assistant.", (Throwable)e));
        }
        int counter = 0;
        while (counter < 100 && this.isContextInfoPopupActive()) {
            try {
                super.hide();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            ++counter;
        }
    }

    private void onCompletionProposalSessionBegin(boolean isAutoActivated) {
        this.completionProposalSession = this.completionProposalSessionRequest != 0 ? this.completionProposalSessionRequest : (isAutoActivated ? 9 : 1);
        this.completionProposalSessionRequest = 0;
        ++this.completionProposalSessionCounter;
        this.completionProposalSelectionCounter = 0;
        this.completionProposalKeyBinding = WorkbenchUIUtils.getBestKeyBinding((String)"org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setRepeatedInvocationTrigger(this.completionProposalKeyBinding);
        this.completionProposalIterationGesture = this.completionProposalKeyBinding != null ? NLS.bind((String)SharedMessages.Affordance_Press_message, (Object)this.completionProposalKeyBinding.format()) : SharedMessages.Affordance_Click_message;
    }

    private void onCompletionProposalComputeBegin(String contentType) {
        this.completionProposalSessionCounter = 0;
        this.completionProposalSelection = null;
    }

    private void onCompletionProposalComputeEnd(String contentType) {
        this.completionProposalSession &= 0xFFFFFFF7;
    }

    private void onCompletionProposalSessionEnd() {
        this.completionProposalSession = 0;
        this.completionProposalSelection = null;
        this.completionProposalKeyBinding = null;
        this.completionProposalIterationGesture = null;
    }

    private void onContextInformationComputeBegin(String contentType) {
        if (this.contextInformationSession == 0) {
            this.contextInformationSession = 9;
        }
    }

    private void onContextInformationComputeEnd(String contentType) {
        this.contextInformationSession = 0;
    }

    public void setContentAssistProcessor(@Nullable IContentAssistProcessor processor, String contentType) {
        if (contentType == null) {
            throw new NullPointerException("contentType");
        }
        if (processor != null && !(processor instanceof Processor)) {
            processor = new WrappedProcessor(this, contentType, processor);
        }
        super.setContentAssistProcessor(processor, contentType);
    }

    public void enableAutoInsert(boolean enabled) {
        this.isAutoInsertEnabled = enabled;
        if (!this.isAutoInsertOverwritten) {
            super.enableAutoInsert(enabled);
        }
    }

    public void setRepeatedInvocationMode(boolean cycling) {
        this.isRepeatedInvocationModeEnabled = cycling;
        super.setRepeatedInvocationMode(cycling);
    }

    void enableAutoInsertTemporarily() {
        this.isAutoInsertOverwritten = true;
        super.enableAutoInsert(true);
    }

    void enableAutoInsertSetting() {
        if (this.isAutoInsertOverwritten) {
            this.isAutoInsertOverwritten = false;
            super.enableAutoInsert(this.isAutoInsertEnabled);
        }
    }

    public void showPossibleCompletions(boolean restart, boolean autostart) {
        if (restart) {
            super.hide();
        }
        if (autostart) {
            class AutoAssist
            extends ContentAssistant.AutoAssistListener {
                public static final int SHOW_PROPOSALS = 1;

                AutoAssist() {
                    super((ContentAssistant)ContentAssist.this);
                }

                public void start(int showStyle) {
                    this.showAssist(showStyle);
                }
            }
            new AutoAssist().start(1);
        } else {
            super.showPossibleCompletions();
        }
    }

    public @Nullable String showPossibleCompletions() {
        this.completionProposalSessionRequest = 1;
        try {
            String string = super.showPossibleCompletions();
            return string;
        }
        finally {
            this.completionProposalSessionRequest = 0;
        }
    }

    public @Nullable String showPossibleCompletions(String categoryId) {
        if (categoryId == null) {
            throw new NullPointerException("categoryId");
        }
        this.completionProposalSessionRequest = 33;
        this.specificCategoryId = categoryId;
        try {
            String string = super.showPossibleCompletions();
            return string;
        }
        finally {
            this.completionProposalSessionRequest = 0;
        }
    }

    void reloadPossibleCompletions() {
        if (this.completionProposalSession == 0 || this.isCompletionProposalAutoRequest() && !this.isProposalPopupActive1()) {
            return;
        }
        this.completionProposalSession |= 0x40;
        this.completionProposalSessionRequest = this.completionProposalSession;
        super.setRepeatedInvocationMode(true);
        try {
            super.showPossibleCompletions();
        }
        finally {
            this.completionProposalSession &= 0xFFFFFFBF;
            this.completionProposalSessionRequest = 0;
            super.setRepeatedInvocationMode(this.isRepeatedInvocationModeEnabled);
        }
    }

    public final boolean isCompletionProposalAutoRequest() {
        return (this.completionProposalSession & 8) != 0;
    }

    final boolean isCompletionProposalReloadRequest() {
        return (this.completionProposalSession & 0x40) != 0;
    }

    public final boolean isCompletionProposalSpecificSession() {
        return (this.completionProposalSession & 0x20) != 0;
    }

    public final @Nullable String getSpecificMode() {
        return this.isCompletionProposalSpecificSession() ? this.specificCategoryId : null;
    }

    public final int getCompletionProposalSessionCounter() {
        return this.completionProposalSessionCounter;
    }

    public @Nullable KeySequence getCompletionProposalKeyBinding() {
        return this.completionProposalKeyBinding;
    }

    public @Nullable String getCompletionProposalIterationGesture() {
        return this.completionProposalIterationGesture;
    }

    public final int getCompletionProposalSelectionCounter() {
        return this.completionProposalSelectionCounter;
    }

    public @Nullable String showContextInformation() {
        if (this.isCompletionProposalSpecificSession() && this.isProposalPopupActive()) {
            this.hide();
        }
        this.contextInformationSession = 1;
        return super.showContextInformation();
    }

    public final boolean isContextInformationAutoRequest() {
        return (this.contextInformationSession & 8) != 0;
    }

    public void setShowSubstringMatches(boolean enabled) {
        this.showSubstringMatchesEnabled = enabled;
    }

    public boolean getShowSubstringMatches() {
        return this.showSubstringMatchesEnabled;
    }

    static abstract class Processor
    implements IContentAssistProcessor {
        private final ContentAssist assist;
        private final String contentType;

        public Processor(ContentAssist assist, String contentType) {
            assert (assist != null);
            assert (contentType != null);
            this.assist = assist;
            this.contentType = contentType;
        }

        public final ContentAssist getAssistant() {
            return this.assist;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final ICompletionProposal @Nullable [] computeCompletionProposals(ITextViewer viewer, int offset) {
            this.assist.onCompletionProposalComputeBegin(this.getContentType());
            try {
                ICompletionProposal[] iCompletionProposalArray = this.doComputeCompletionProposals(viewer, offset);
                return iCompletionProposalArray;
            }
            finally {
                this.assist.onCompletionProposalComputeEnd(this.getContentType());
            }
        }

        protected abstract ICompletionProposal @Nullable [] doComputeCompletionProposals(ITextViewer var1, int var2);

        public final IContextInformation @Nullable [] computeContextInformation(ITextViewer viewer, int offset) {
            this.assist.onContextInformationComputeBegin(this.getContentType());
            try {
                IContextInformation[] iContextInformationArray = this.doComputeContextInformation(viewer, offset);
                return iContextInformationArray;
            }
            finally {
                this.assist.onContextInformationComputeEnd(this.getContentType());
            }
        }

        protected abstract IContextInformation @Nullable [] doComputeContextInformation(ITextViewer var1, int var2);
    }

    private class SelfListener
    implements ICompletionListener,
    ICompletionListenerExtension {
        private SelfListener() {
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            ContentAssist.this.onCompletionProposalSessionBegin(event.isAutoActivated);
        }

        public void assistSessionRestarted(ContentAssistEvent event) {
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            ContentAssist.this.onCompletionProposalSessionEnd();
        }

        public void selectionChanged(@Nullable ICompletionProposal proposal, boolean smartToggle) {
            if (proposal != ContentAssist.this.completionProposalSelection) {
                ContentAssist.this.completionProposalSelection = proposal;
                ContentAssist contentAssist = ContentAssist.this;
                contentAssist.completionProposalSelectionCounter = contentAssist.completionProposalSelectionCounter + 1;
            }
        }
    }

    private static class WrappedProcessor
    extends Processor {
        private final IContentAssistProcessor processor;

        public WrappedProcessor(ContentAssist assist, String contentType, IContentAssistProcessor processor) {
            super(assist, contentType);
            this.processor = processor;
        }

        public char @Nullable [] getCompletionProposalAutoActivationCharacters() {
            return this.processor.getCompletionProposalAutoActivationCharacters();
        }

        public char @Nullable [] getContextInformationAutoActivationCharacters() {
            return this.processor.getContextInformationAutoActivationCharacters();
        }

        @Override
        protected ICompletionProposal @Nullable [] doComputeCompletionProposals(ITextViewer viewer, int offset) {
            return this.processor.computeCompletionProposals(viewer, offset);
        }

        @Override
        protected IContextInformation @Nullable [] doComputeContextInformation(ITextViewer viewer, int offset) {
            return this.processor.computeContextInformation(viewer, offset);
        }

        public @Nullable String getErrorMessage() {
            return this.processor.getErrorMessage();
        }

        public @Nullable IContextInformationValidator getContextInformationValidator() {
            return this.processor.getContextInformationValidator();
        }
    }
}

