/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.ecommons.text.IMarkerPositionResolver;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class AnnotationMarkerPositionResolver
implements IMarkerPositionResolver {
    private final IDocument fDocument;
    private final AbstractMarkerAnnotationModel fAnnotationModel;

    public static IMarkerPositionResolver createIfRequired(IResource file) {
        ITextFileBuffer buffer;
        if (file.getType() == 1 && (buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE)) != null) {
            IDocument document = buffer.getDocument();
            IAnnotationModel model = buffer.getAnnotationModel();
            if (model instanceof AbstractMarkerAnnotationModel) {
                return new AnnotationMarkerPositionResolver(document, (AbstractMarkerAnnotationModel)model);
            }
        }
        return null;
    }

    public AnnotationMarkerPositionResolver(IDocument document, AbstractMarkerAnnotationModel model) {
        this.fDocument = document;
        this.fAnnotationModel = model;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position getPosition(IMarker marker) {
        Object object = this.fAnnotationModel.getLockObject();
        synchronized (object) {
            return this.fAnnotationModel.getMarkerPosition(marker);
        }
    }

    public int getLine(IMarker marker) {
        Position position = this.getPosition(marker);
        if (position != null) {
            try {
                return this.fDocument.getLineOfOffset(position.getOffset()) + 1;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return -1;
    }
}

