/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class RequestSync {
    private @Nullable RequestKey expliciteRequest;
    private @Nullable RequestKey linkRequest;

    public synchronized @Nullable RequestKey newRequest(boolean explicite) {
        if (explicite) {
            if (this.linkRequest != null) {
                this.linkRequest.cancel();
                this.linkRequest = null;
            }
            if (this.expliciteRequest != null) {
                this.expliciteRequest.cancel();
                this.expliciteRequest = null;
            }
            this.expliciteRequest = new RequestKey(true);
            return this.expliciteRequest;
        }
        if (this.expliciteRequest == null) {
            return new RequestKey(false);
        }
        return null;
    }

    public synchronized boolean startRequest(RequestKey request) {
        if (request.isExplicite) {
            return request.isValid();
        }
        if (this.expliciteRequest == null) {
            if (this.linkRequest != null) {
                this.linkRequest.cancel();
                this.linkRequest = null;
            }
            this.linkRequest = request;
            return true;
        }
        return false;
    }

    public synchronized void deleteRequest(RequestKey request) {
        if (request.isExplicite) {
            if (this.expliciteRequest == request) {
                this.expliciteRequest = null;
            }
        } else if (this.linkRequest == request) {
            this.linkRequest = null;
        }
    }

    public static final class RequestKey {
        private final boolean isExplicite;
        private volatile boolean isCanceled;
        @Nullable Job job;

        public RequestKey(boolean explicite) {
            this.isExplicite = explicite;
        }

        public boolean isExplicite() {
            return this.isExplicite;
        }

        public void setAsync(Job job) {
            this.job = job;
            if (this.isCanceled) {
                job.cancel();
            }
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public void cancel() {
            this.isCanceled = true;
            Job job = this.job;
            if (job != null) {
                job.cancel();
            }
        }

        public boolean isValid() {
            return !this.isCanceled;
        }
    }
}

