/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.statet.internal.rhelp.core.REnvHelpIndex;
import org.eclipse.statet.internal.rhelp.core.RHelpCoreInternals;
import org.eclipse.statet.internal.rhelp.core.RHelpSearchMatchImpl;
import org.eclipse.statet.internal.rhelp.core.SerUtil;
import org.eclipse.statet.internal.rhelp.core.index.DocFieldVisitorCollector;
import org.eclipse.statet.internal.rhelp.core.index.Highlighter;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexSchema;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexSearchQuery;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexUtils;
import org.eclipse.statet.internal.rhelp.core.index.RequestStreamCollector;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.WarningStatus;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpSearchMatch;
import org.eclipse.statet.rhelp.core.RHelpSearchQuery;
import org.eclipse.statet.rhelp.core.RHelpSearchRequestor;
import org.eclipse.statet.rhelp.core.RPkgHelp;

@NonNullByDefault
public class REnvIndexReader
implements REnvIndexSchema,
REnvHelpIndex {
    private static final ImSet<String> LOAD_ID_SELECTOR = ImCollections.newSet((Object[])new String[]{"page", "pkg"});
    private static final ImSet<String> LOAD_HTML_SELECTOR = ImCollections.newSet((Object)"doc.html");
    private static final ImList<String> DOC_HTML_SEARCH_FIELDS = ImCollections.newList((Object)"doc.html");
    static final Query DOCTYPE_PKG_DESCRIPTION_FILTER = new TermQuery(new Term("doctype", "RPkgDescription"));
    static final Query DOCTYPE_PAGE_FILTER = new TermQuery(new Term("doctype", "RHelpPage"));
    private static final Highlighter HTML_PAGE_QUERY_HIGHLIGHTER = new Highlighter(true, true, null, null);
    private final IndexReader indexReader;
    private IndexSearcher indexSearcher;

    public REnvIndexReader(REnvHelpConfiguration rEnvConfig) throws Exception {
        FSDirectory directory = REnvIndexUtils.getDirectory(SerUtil.getIndexDirectoryChecked(rEnvConfig));
        this.indexReader = DirectoryReader.open((Directory)directory);
        this.indexSearcher = new IndexSearcher(this.indexReader);
        this.indexSearcher.setSimilarity(SIMILARITY);
    }

    private void check() {
        if (this.indexSearcher == null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void dispose() {
        if (this.indexSearcher != null) {
            try {
                try {
                    this.indexReader.close();
                }
                catch (IOException e) {
                    RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "An error occurred when disposing searcher for the R help index.", (Throwable)e));
                    this.indexSearcher = null;
                }
            }
            finally {
                this.indexSearcher = null;
            }
        }
    }

    private StatusException onFailed(Exception e, String description) {
        ErrorStatus status = new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("R help index - Failed to perform search.\n\trequest= %1$s", description), (Throwable)e);
        RHelpCoreInternals.log((Status)status);
        return new StatusException((Status)status);
    }

    @Override
    public List<RHelpPage> getPagesForTopic(final String topic, final Map<String, RPkgHelp> packageMap, int timeout, @Nullable ProgressMonitor m) throws StatusException {
        this.check();
        try {
            ImList filters = ImCollections.newList((Object[])new Query[]{new TermQuery(new Term("alias", topic)), DOCTYPE_PAGE_FILTER});
            final ArrayList<RHelpPage> pages = new ArrayList<RHelpPage>();
            this.indexSearcher.search(this.createSearchQuery(null, (ImList<Query>)filters), (Collector)new DocFieldVisitorCollector(new DocFieldVisitorCollector.Visitor((Set)LOAD_ID_SELECTOR){
                private @Nullable String pkgName;
                private @Nullable String pageName;

                @Override
                public void newDocMatch(int doc, float score) {
                    this.pkgName = null;
                    this.pageName = null;
                }

                public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
                    switch (fieldInfo.name) {
                        case "pkg": {
                            this.pkgName = REnvIndexUtils.toString(value);
                            return;
                        }
                        case "page": {
                            this.pageName = REnvIndexUtils.toString(value);
                            return;
                        }
                    }
                }

                @Override
                public void finalizeDocMatch() {
                    if (this.pkgName != null && this.pageName != null) {
                        RHelpPage page;
                        RPkgHelp pkgHelp = (RPkgHelp)packageMap.get(this.pkgName);
                        if (pkgHelp != null && (page = pkgHelp.getPage(this.pageName)) != null) {
                            pages.add(page);
                            return;
                        }
                        RHelpCoreInternals.log((Status)new WarningStatus("org.eclipse.statet.rhelp.core", String.format("R help index - Unexpected search result: page not found\n\tpage= %1$s?%2$s\n\trequest= %3$s", this.pkgName, this.pageName, REnvIndexReader.this.getPagesForTopicDescription(topic))));
                    }
                }
            }));
            return pages;
        }
        catch (Exception e) {
            throw this.onFailed(e, this.getPagesForTopicDescription(topic));
        }
    }

    private String getPagesForTopicDescription(String topic) {
        return String.format("pages-for-topic '%1$s'", topic);
    }

    @Override
    public @Nullable String getHtmlPage(RPkgHelp pkgHelp, String pageName, @Nullable String queryString, int timeout, @Nullable ProgressMonitor m) throws StatusException {
        this.check();
        String pkgName = pkgHelp.getName();
        try {
            ImList filters = ImCollections.newList((Object[])new Query[]{new TermQuery(new Term("pkg", pkgName)), new TermQuery(new Term("page", pageName)), DOCTYPE_PAGE_FILTER});
            TopDocs docs = this.indexSearcher.search(this.createSearchQuery(null, (ImList<Query>)filters), 1);
            if (docs.totalHits > 1L) {
                RHelpCoreInternals.log((Status)new WarningStatus("org.eclipse.statet.rhelp.core", String.format("R help index - Unexpected search result: total hits= %1$s.\n\trequest= %2$s", docs.totalHits, this.getHtmlPageDescription(pkgName, pageName))));
            }
            if (docs.totalHits >= 1L) {
                int docId = docs.scoreDocs[0].doc;
                Document document = this.indexSearcher.doc(docs.scoreDocs[0].doc, LOAD_HTML_SELECTOR);
                if (queryString != null && !queryString.isEmpty()) {
                    FieldQuery fieldQuery = HTML_PAGE_QUERY_HIGHLIGHTER.getFieldQuery(REnvIndexSearchQuery.createMainQuery(queryString, DOC_HTML_SEARCH_FIELDS, null), this.indexReader);
                    return HTML_PAGE_QUERY_HIGHLIGHTER.getComplete(fieldQuery, this.indexReader, docId, "doc.html", RHelpSearchMatch.PRE_TAGS, RHelpSearchMatch.POST_TAGS, Highlighter.DEFAULT_ENCODER);
                }
                return document.get("doc.html");
            }
            return null;
        }
        catch (Exception e) {
            throw this.onFailed(e, this.getHtmlPageDescription(pkgName, pageName));
        }
    }

    private String getHtmlPageDescription(String pkgName, String pageName) {
        return String.format("html-page %1$s?%2$s", pkgName, pageName);
    }

    @Override
    public void search(RHelpSearchQuery searchQuery, List<RPkgHelp> packageList, Map<String, RPkgHelp> packageMap, RHelpSearchRequestor requestor) throws StatusException {
        this.check();
        try {
            REnvIndexSearchQuery indexQuery = searchQuery.getIndexQuery();
            if (indexQuery.getQuery() == null && indexQuery.getFilters().size() == 1 && indexQuery.getFilters().get(0) == DOCTYPE_PAGE_FILTER) {
                for (RPkgHelp pkgHelp : packageList) {
                    for (RHelpPage page : pkgHelp.getPages()) {
                        requestor.matchFound(new RHelpSearchMatchImpl(page, 1.0f));
                    }
                }
            } else {
                this.indexSearcher.search(this.createSearchQuery(indexQuery.getQuery(), indexQuery.getFilters()), (Collector)new DocFieldVisitorCollector(new RequestStreamCollector(indexQuery, packageMap, requestor)));
            }
        }
        catch (Exception e) {
            throw this.onFailed(e, String.format("text-search '%1$s'", searchQuery));
        }
    }

    private Query createSearchQuery(@Nullable Query query, ImList<Query> filters) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add((Query)(query != null ? query : new MatchAllDocsQuery()), BooleanClause.Occur.MUST);
        for (Query filter : filters) {
            queryBuilder.add(filter, BooleanClause.Occur.FILTER);
        }
        return queryBuilder.build();
    }
}

