/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ltk.core.DefaultSourceUnitIdFactory;
import org.eclipse.statet.internal.ltk.core.LtkCorePlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.ltk.core.IExtContentTypeManager;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.model.core.ModelTypeDescriptor;
import org.eclipse.statet.ltk.model.core.SourceUnitFactory;
import org.eclipse.statet.ltk.model.core.SourceUnitIdFactory;
import org.eclipse.statet.ltk.model.core.SourceUnitManager;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

@NonNullByDefault
public class SourceUnitManagerImpl
implements SourceUnitManager,
Disposable {
    private static final String CONFIG_MODELTYPE_ID_ATTRIBUTE_NAME = "modelTypeId";
    private static final String CONFIG_CONTEXT_KEY_ATTRIBUTE_NAME = "contextKey";
    private final CleanupJob cleanupJob = new CleanupJob();
    private volatile ImList<ModelItem> modelItems = ImCollections.newList();
    private final SourceUnitIdFactory defaultIdFactory = new DefaultSourceUnitIdFactory();
    private final IExtContentTypeManager contentManager = Ltk.getExtContentTypeManager();

    public SourceUnitManagerImpl() {
        this.cleanupJob.initialSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performCleanup() {
        int count = 0;
        ImList<ModelItem> modelItems = this.modelItems;
        for (ModelItem modelItem : modelItems) {
            ImList<ContextItem> contextItems = modelItem.contextItems;
            for (ContextItem contextItem : contextItems) {
                SuItem suItem;
                while ((suItem = (SuItem)contextItem.susToClean.poll()) != null) {
                    HashMap<String, SuItem> hashMap = contextItem.sus;
                    synchronized (hashMap) {
                        if (contextItem.sus.get(suItem.getKey()) == suItem) {
                            contextItem.sus.remove(suItem.getKey());
                        }
                        suItem.dispose();
                        ++count;
                    }
                }
            }
        }
        return count;
    }

    public void dispose() {
        this.cleanupJob.dispose();
    }

    @Override
    public final @Nullable String getSourceUnitId(Object from) {
        ObjectUtils.nonNullAssert((Object)from);
        if (from instanceof SourceUnit) {
            return ((SourceUnit)from).getId();
        }
        return this.defaultIdFactory.createId(from);
    }

    @Override
    public SourceUnit getSourceUnit(String modelTypeId, WorkingContext context, Object from, IProgressMonitor monitor) throws StatusException {
        String sourceUnitId;
        ObjectUtils.nonNullAssert((Object)modelTypeId);
        ObjectUtils.nonNullAssert((Object)context);
        if (from instanceof SourceUnit) {
            SourceUnit fromUnit = (SourceUnit)from;
            sourceUnitId = fromUnit.getId();
        } else {
            Object fromUnit = null;
            sourceUnitId = this.defaultIdFactory.createId(from);
            if (sourceUnitId == null) {
                throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.ltk.core", NLS.bind((String)"Unsupported object type for source unit: ''{0}''.", from.getClass())));
            }
        }
        return this.getSourceUnit2(modelTypeId, context, sourceUnitId, from, monitor);
    }

    @Override
    public SourceUnit getSourceUnit(WorkingContext context, SourceUnit from, boolean disconnectFrom, IProgressMonitor monitor) throws StatusException {
        ObjectUtils.nonNullAssert((Object)context);
        SourceUnit sourceUnit = this.getSourceUnit2(from.getModelTypeId(), context, from.getId(), from, monitor);
        if (disconnectFrom) {
            from.disconnect(monitor);
        }
        return sourceUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceUnit getSourceUnit2(String modelTypeId, WorkingContext context, String sourceUnitId, Object from, IProgressMonitor monitor) throws StatusException {
        ModelItem modelItem = this.getModelItem(modelTypeId);
        ContextItem contextItem = modelItem.getContextItem(context, true);
        if (contextItem == null) {
            ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("Cannot provide the source unit: no factory is defined for the request.");
            sb.addProp("modelType", modelTypeId);
            sb.addProp("context", (Object)context);
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.ltk.core", sb.build()));
        }
        SourceUnit sourceUnit = null;
        ContextItem contextItem2 = contextItem;
        synchronized (contextItem2) {
            SuItem suItem = contextItem.sus.get(sourceUnitId);
            if (suItem != null && !suItem.refersTo(sourceUnit = (SourceUnit)suItem.get())) {
                sourceUnit = null;
            }
            if (sourceUnit == null) {
                sourceUnit = contextItem.factory.createSourceUnit(sourceUnitId, from);
                if (sourceUnit == null) {
                    ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("Cannot provide the source unit: the factory does not seem to support the request.");
                    sb.addProp("modelType", modelTypeId);
                    sb.addProp("context", (Object)context);
                    sb.addProp("factory", (Object)contextItem.factory);
                    sb.addProp("from", from);
                    throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.ltk.core", sb.build()));
                }
                if (sourceUnit.getModelTypeId() != modelItem.modelTypeId || sourceUnit.getWorkingContext() != context || (sourceUnit.getElementType() & 0xF00) != 512) {
                    ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("Cannot provide source unit: object created by the factory does not comply with the request.");
                    sb.addProp("modelType", modelTypeId);
                    sb.addProp("context", (Object)context);
                    sb.addProp("factory", (Object)contextItem.factory);
                    sb.addProp("from", from);
                    sb.addProp("sourceUnit", (Object)sourceUnit);
                    sb.addPropHex("sourceUnit.elementType", sourceUnit.getElementType());
                    throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.ltk.core", sb.build()));
                }
                suItem = new SuItem(sourceUnitId, sourceUnit, contextItem.susToClean);
                contextItem.sus.put(sourceUnitId, suItem);
            }
        }
        sourceUnit.connect(monitor);
        return sourceUnit;
    }

    @Override
    public @Nullable SourceUnit getSourceUnit(WorkingContext context, Object from, @Nullable IContentType contentType, boolean create, IProgressMonitor monitor) {
        String sourceUnitId;
        String modelTypeId;
        SourceUnit fromUnit;
        ObjectUtils.nonNullAssert((Object)context);
        if (from instanceof SourceUnit) {
            fromUnit = (SourceUnit)from;
            modelTypeId = fromUnit.getModelTypeId();
            sourceUnitId = fromUnit.getId();
        } else {
            fromUnit = null;
            modelTypeId = this.detectModelTypeId(from, null);
            if (modelTypeId == null) {
                return null;
            }
            sourceUnitId = this.defaultIdFactory.createId(from);
            if (sourceUnitId == null) {
                return null;
            }
        }
        return this.getSourceUnit1(modelTypeId, context, sourceUnitId, from, fromUnit, create, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable SourceUnit getSourceUnit1(String modelTypeId, WorkingContext context, String sourceUnitId, Object from, @Nullable SourceUnit fromUnit, boolean create, IProgressMonitor monitor) {
        SourceUnit sourceUnit;
        block12: {
            ModelItem modelItem = this.getModelItem(modelTypeId);
            ContextItem contextItem = modelItem.getContextItem(context, create);
            if (contextItem == null) {
                if (create) {
                    ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("Cannot provide the source unit: no factory is defined for the request.");
                    sb.addProp("modelType", modelTypeId);
                    sb.addProp("context", (Object)context);
                    throw new UnsupportedOperationException(sb.build());
                }
                return null;
            }
            sourceUnit = null;
            ContextItem contextItem2 = contextItem;
            synchronized (contextItem2) {
                SuItem suItem;
                block11: {
                    block10: {
                        suItem = contextItem.sus.get(sourceUnitId);
                        if (suItem != null && !suItem.refersTo(sourceUnit = (SourceUnit)suItem.get())) {
                            sourceUnit = null;
                        }
                        if (sourceUnit != null || !create) break block12;
                        sourceUnit = contextItem.factory.createSourceUnit(sourceUnitId, from);
                        if (sourceUnit != null) break block10;
                        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("Cannot provide the source unit: the factory does not seem to support the request.");
                        sb.addProp("modelType", modelTypeId);
                        sb.addProp("context", (Object)context);
                        sb.addProp("factory", (Object)contextItem.factory);
                        sb.addProp("from", from);
                        LtkCorePlugin.log((Status)new ErrorStatus("org.eclipse.statet.ltk.core", sb.build()));
                        return null;
                    }
                    if (sourceUnit.getModelTypeId() == modelItem.modelTypeId && sourceUnit.getWorkingContext() == context && (sourceUnit.getElementType() & 0xF00) == 512) break block11;
                    ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("Cannot provide source unit: object created by the factory does not comply with the request.");
                    sb.addProp("modelType", modelTypeId);
                    sb.addProp("context", (Object)context);
                    sb.addProp("factory", (Object)contextItem.factory);
                    sb.addProp("from", from);
                    sb.addProp("sourceUnit", (Object)sourceUnit);
                    sb.addPropHex("sourceUnit.elementType", sourceUnit.getElementType());
                    LtkCorePlugin.log((Status)new ErrorStatus("org.eclipse.statet.ltk.core", sb.build()));
                    return null;
                }
                suItem = new SuItem(sourceUnitId, sourceUnit, contextItem.susToClean);
                contextItem.sus.put(sourceUnitId, suItem);
            }
        }
        if (sourceUnit == null) {
            return null;
        }
        sourceUnit.connect(monitor);
        if (fromUnit != null) {
            fromUnit.disconnect(monitor);
        }
        return sourceUnit;
    }

    @Override
    public @Nullable SourceUnit getOpenSourceUnit(String modelTypeId, WorkingContext context, Object from) {
        ObjectUtils.nonNullAssert((Object)modelTypeId);
        ObjectUtils.nonNullAssert((Object)context);
        String sourceUnitId = this.getSourceUnitId(from);
        if (sourceUnitId == null) {
            return null;
        }
        return this.getOpenSourceUnit2(modelTypeId, context, sourceUnitId);
    }

    @Override
    public @Nullable SourceUnit getOpenSourceUnit(WorkingContext context, Object from) {
        String sourceUnitId;
        String modelTypeId;
        ObjectUtils.nonNullAssert((Object)context);
        if (from instanceof SourceUnit) {
            SourceUnit fromUnit = (SourceUnit)from;
            modelTypeId = fromUnit.getModelTypeId();
            sourceUnitId = fromUnit.getId();
        } else {
            modelTypeId = this.detectModelTypeId(from, null);
            if (modelTypeId == null) {
                return null;
            }
            sourceUnitId = this.defaultIdFactory.createId(from);
            if (sourceUnitId == null) {
                return null;
            }
        }
        return this.getOpenSourceUnit2(modelTypeId, context, sourceUnitId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable SourceUnit getOpenSourceUnit2(String modelTypeId, WorkingContext context, String sourceUnitId) {
        ModelItem modelItem = this.getModelItem(modelTypeId);
        ContextItem contextItem = modelItem.getContextItem(context, false);
        if (contextItem == null) {
            return null;
        }
        SourceUnit sourceUnit = null;
        ContextItem contextItem2 = contextItem;
        synchronized (contextItem2) {
            SuItem suItem = contextItem.sus.get(sourceUnitId);
            if (suItem != null && !suItem.refersTo(sourceUnit = (SourceUnit)suItem.get())) {
                sourceUnit = null;
            }
        }
        return sourceUnit;
    }

    @Override
    public List<SourceUnit> getOpenSourceUnits(String modelTypeId, @Nullable WorkingContext context) {
        List<ModelItem> modelItems = this.getOpenModelItems(modelTypeId);
        if (modelItems.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SourceUnit> list = new ArrayList<SourceUnit>();
        for (ModelItem modelItem : modelItems) {
            ImList<ContextItem> contextItems = modelItem.getOpenContextItems(context);
            if (contextItems.isEmpty()) continue;
            for (ContextItem contextItem : contextItems) {
                contextItem.appendOpenSus(list);
            }
        }
        return list;
    }

    @Override
    public List<SourceUnit> getOpenSourceUnits(List<String> modelTypeIds, @Nullable WorkingContext context) {
        List<ModelItem> includedModelItems = this.getOpenModelItems(modelTypeIds);
        if (includedModelItems.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SourceUnit> list = new ArrayList<SourceUnit>(4);
        int i = 0;
        while (i < includedModelItems.size()) {
            ImList<ContextItem> contextItems = ((ModelItem)this.modelItems.get(i)).getOpenContextItems(context);
            if (!contextItems.isEmpty()) {
                for (ContextItem contextItem : contextItems) {
                    contextItem.appendOpenSus(list);
                }
            }
            ++i;
        }
        return list;
    }

    @Override
    public List<SourceUnit> getOpenSourceUnits(List<String> modelTypeIds, @Nullable WorkingContext context, String sourceUnitId) {
        List<ModelItem> includedModelItems = this.getOpenModelItems(modelTypeIds);
        if (includedModelItems.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SourceUnit> list = new ArrayList<SourceUnit>(4);
        int i = 0;
        while (i < includedModelItems.size()) {
            ImList<ContextItem> contextItems = ((ModelItem)this.modelItems.get(i)).getOpenContextItems(context);
            if (!contextItems.isEmpty()) {
                for (ContextItem contextItem : contextItems) {
                    SourceUnit su = contextItem.getOpenSu(sourceUnitId);
                    if (su == null) continue;
                    list.add(su);
                }
            }
            ++i;
        }
        return list;
    }

    @Override
    public List<SourceUnit> getOpenSourceUnits(List<String> modelTypeIds, @Nullable WorkingContext context, Object from) {
        String sourceUnitId = this.getSourceUnitId(from);
        if (sourceUnitId == null) {
            return ImCollections.emptyList();
        }
        return this.getOpenSourceUnits(modelTypeIds, context, sourceUnitId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private @Nullable IContentType detectContentType(Object from) {
        InputStream in;
        block12: {
            IContentType iContentType;
            block11: {
                if (!(from instanceof IFile)) break block11;
                IFile file = (IFile)from;
                IContentDescription contentDescription = file.getContentDescription();
                if (contentDescription == null) return null;
                return contentDescription.getContentType();
            }
            if (!(from instanceof IFileStore)) return null;
            IFileStore file = (IFileStore)from;
            Throwable throwable = null;
            Object var5_8 = null;
            in = file.openInputStream(0, null);
            try {
                IContentDescription contentDescription = Platform.getContentTypeManager().getDescriptionFor(in, file.getName(), IContentDescription.ALL);
                if (contentDescription == null) break block12;
                iContentType = contentDescription.getContentType();
                if (in == null) return iContentType;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (in == null) throw throwable2;
                        in.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        } else {
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | UnsupportedOperationException | CoreException e) {
                    LtkCorePlugin.log((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.ltk.core", 0, "An error occurred when trying to detect content type of " + String.valueOf(from), e));
                    return null;
                }
            }
            in.close();
            return iContentType;
        }
        if (in == null) return null;
        in.close();
        return null;
    }

    private @Nullable String detectModelTypeId(Object from, @Nullable IContentType contentType) {
        if (contentType == null && (contentType = this.detectContentType(from)) == null) {
            return null;
        }
        ModelTypeDescriptor modelType = this.contentManager.getModelTypeForContentType(contentType.getId());
        return modelType != null ? modelType.getId() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelItem getModelItem(String modelTypeId) {
        ImList<ModelItem> modelItems = this.modelItems;
        for (ModelItem modelItem : modelItems) {
            if (modelItem.modelTypeId != modelTypeId) continue;
            return modelItem;
        }
        SourceUnitManagerImpl sourceUnitManagerImpl = this;
        synchronized (sourceUnitManagerImpl) {
            if (modelItems != this.modelItems) {
                return this.getModelItem(modelTypeId);
            }
            ModelItem modelItem = new ModelItem(modelTypeId);
            this.modelItems = ImCollections.addElement(modelItems, (Object)modelItem);
            return modelItem;
        }
    }

    private List<ModelItem> getOpenModelItems(@Nullable String modelTypeId) {
        ImList<ModelItem> modelItems = this.modelItems;
        if (modelTypeId != null) {
            for (ModelItem modelItem : modelItems) {
                if (modelItem.modelTypeId != modelTypeId) continue;
                return ImCollections.newList((Object)modelItem);
            }
            return ImCollections.emptyList();
        }
        return modelItems;
    }

    private List<ModelItem> getOpenModelItems(@Nullable List<String> modelTypeIds) {
        ImList<ModelItem> modelItems = this.modelItems;
        if (modelTypeIds != null) {
            ArrayList<ModelItem> matches = new ArrayList<ModelItem>(modelTypeIds.size());
            for (ModelItem modelItem : modelItems) {
                if (!modelTypeIds.contains(modelItem.modelTypeId)) continue;
                matches.add(modelItem);
            }
            return matches;
        }
        return modelItems;
    }

    private class CleanupJob
    extends Job {
        private final Object scheduleLock;

        public CleanupJob() {
            super("SourceUnit Cleanup");
            this.scheduleLock = new Object();
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(50);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void initialSchedule() {
            Object object = this.scheduleLock;
            synchronized (object) {
                this.schedule(180000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispose() {
            Object object = this.scheduleLock;
            synchronized (object) {
                this.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            int count = SourceUnitManagerImpl.this.performCleanup();
            Object object = this.scheduleLock;
            synchronized (object) {
                if (monitor.isCanceled()) {
                    return org.eclipse.core.runtime.Status.CANCEL_STATUS;
                }
                this.schedule(count > 0 ? 60000 : 180000);
                return org.eclipse.core.runtime.Status.OK_STATUS;
            }
        }
    }

    private static class ContextItem {
        private final WorkingContext context;
        private final SourceUnitFactory factory;
        private final HashMap<String, SuItem> sus;
        private final ReferenceQueue<SourceUnit> susToClean;

        public ContextItem(WorkingContext context, SourceUnitFactory factory) {
            this.context = context;
            this.factory = factory;
            this.sus = new HashMap();
            this.susToClean = new ReferenceQueue();
        }

        public int hashCode() {
            return this.context.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof ContextItem) {
                return ((ContextItem)obj).context == this.context;
            }
            return false;
        }

        public synchronized @Nullable SourceUnit getOpenSu(String id) {
            SourceUnit su;
            SuItem suItem = this.sus.get(id);
            if (suItem != null && (su = (SourceUnit)suItem.get()) != null && suItem.refersTo(su)) {
                return su;
            }
            return null;
        }

        public synchronized void appendOpenSus(ArrayList<SourceUnit> list) {
            Collection<SuItem> suItems = this.sus.values();
            list.ensureCapacity(list.size() + suItems.size());
            for (SuItem suItem : suItems) {
                SourceUnit su = (SourceUnit)suItem.get();
                if (su == null || !suItem.refersTo(su)) continue;
                list.add(su);
            }
        }
    }

    private static class ModelItem {
        private final String modelTypeId;
        private volatile ImList<ContextItem> contextItems = ImCollections.newList();

        public ModelItem(String modelTypeId) {
            this.modelTypeId = modelTypeId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable ContextItem getContextItem(WorkingContext context, boolean create) {
            ImList<ContextItem> contextItems = this.contextItems;
            for (ContextItem contextItem : contextItems) {
                if (contextItem.context != context) continue;
                return contextItem;
            }
            if (create) {
                ModelItem modelItem = this;
                synchronized (modelItem) {
                    if (contextItems != this.contextItems) {
                        return this.getContextItem(context, true);
                    }
                    try {
                        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.statet.ltk.ModelTypes");
                        IConfigurationElement matchingElement = null;
                        IConfigurationElement[] iConfigurationElementArray = elements;
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConfigurationElement element = iConfigurationElementArray[n2];
                            if (element.getName().equals("unitType") && element.isValid()) {
                                String typeIdOfElement = element.getAttribute(SourceUnitManagerImpl.CONFIG_MODELTYPE_ID_ATTRIBUTE_NAME);
                                String contextKeyOfElement = element.getAttribute(SourceUnitManagerImpl.CONFIG_CONTEXT_KEY_ATTRIBUTE_NAME);
                                if (this.modelTypeId.equals(typeIdOfElement)) {
                                    if (contextKeyOfElement == null || contextKeyOfElement.length() == 0) {
                                        matchingElement = element;
                                    } else if (contextKeyOfElement.equals(context.getKey())) {
                                        matchingElement = element;
                                        break;
                                    }
                                }
                            }
                            ++n2;
                        }
                        if (matchingElement != null) {
                            SourceUnitFactory factory = (SourceUnitFactory)matchingElement.createExecutableExtension("unitFactory");
                            ContextItem contextItem = new ContextItem(context, factory);
                            this.contextItems = ImCollections.addElement(contextItems, (Object)contextItem);
                            return contextItem;
                        }
                    }
                    catch (Exception e) {
                        LtkCorePlugin.log((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.ltk.core", 0, "Error loading working context contributions", (Throwable)e));
                    }
                }
            }
            return null;
        }

        public ImList<ContextItem> getOpenContextItems(@Nullable WorkingContext context) {
            ImList<ContextItem> contextItems = this.contextItems;
            if (context != null) {
                for (ContextItem contextItem : contextItems) {
                    if (contextItem.context != context) continue;
                    return ImCollections.newList((Object)contextItem);
                }
                return ImCollections.emptyList();
            }
            return contextItems;
        }

        public int hashCode() {
            return this.modelTypeId.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof ModelItem && this.modelTypeId.equals(((ModelItem)obj).modelTypeId);
        }
    }

    private static final class SuItem
    extends SoftReference<SourceUnit> {
        private final String key;

        public SuItem(String key, SourceUnit su, ReferenceQueue<SourceUnit> queue) {
            super(su, queue);
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void dispose() {
            SourceUnit su = (SourceUnit)this.get();
            if (su != null && su.isConnected()) {
                LtkCorePlugin.log((IStatus)new org.eclipse.core.runtime.Status(2, "org.eclipse.statet.ltk.core", -1, NLS.bind((String)"Source Unit ''{0}'' disposed but connected.", (Object)su.getId()), null));
            }
            this.clear();
        }
    }
}

