/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.console;

import java.util.Objects;
import org.eclipse.statet.jcommons.graphic.core.ColorDef;
import org.eclipse.statet.jcommons.lang.Immutable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class StyleData
implements Immutable {
    public static final byte NONE = 0;
    public static final byte UNDERLINE_SINGLE = 1;
    public static final byte UNDERLINE_DOUBLE = 2;
    private static final int F_BOLD = 1;
    private static final int F_ITALIC = 2;
    private static final int F_UNDERLINE_SHIFT = 2;
    private static final int F_UNDERLINE_MASK = 3;
    private static final int F_STRIKETHROUGH = 16;
    private static final int F_FRAMED = 32;
    private static final int F_INVERT = 512;
    private static final int F_HIDE = 1024;
    private int flags;
    private @Nullable ColorDef foregroundColor;
    private @Nullable ColorDef backgroundColor;

    public StyleData() {
    }

    private StyleData(int flags, @Nullable ColorDef foregroundColor, @Nullable ColorDef backgroundColor) {
        this.flags = flags;
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
    }

    public boolean isEmpty() {
        return this.flags == 0 && this.foregroundColor == null && this.backgroundColor == null;
    }

    public @Nullable ColorDef getForegroundColor() {
        return this.foregroundColor;
    }

    public @Nullable ColorDef getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean getBold() {
        return (this.flags & 1) != 0;
    }

    public boolean getItalic() {
        return (this.flags & 2) != 0;
    }

    public byte getUnderline() {
        return (byte)(this.flags >>> 2 & 3);
    }

    public boolean getStrikethrough() {
        return (this.flags & 0x10) != 0;
    }

    public boolean getFramed() {
        return (this.flags & 0x20) != 0;
    }

    public boolean getInvert() {
        return (this.flags & 0x200) != 0;
    }

    public boolean getHide() {
        return (this.flags & 0x400) != 0;
    }

    public int hashCode() {
        int h = this.flags;
        h = 31 * h + Objects.hashCode(this.foregroundColor);
        h = 31 * h + Objects.hashCode(this.backgroundColor);
        return h;
    }

    public boolean equals(@Nullable Object obj) {
        block4: {
            block5: {
                if (this == obj) {
                    return true;
                }
                if (this == obj) break block4;
                if (!(obj instanceof StyleData)) break block5;
                StyleData other = (StyleData)obj;
                if (this.flags == other.flags && Objects.equals(this.foregroundColor, other.foregroundColor) && Objects.equals(this.backgroundColor, other.backgroundColor)) break block4;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(this.getClass());
        sb.addProp("ForegroundColor", (Object)this.getForegroundColor());
        sb.addProp("BackgroundColor", (Object)this.getBackgroundColor());
        sb.addProp("Bold", this.getBold());
        sb.addProp("Italic", this.getItalic());
        sb.addProp("Underline", (int)this.getUnderline());
        sb.addProp("Strikethrough", this.getStrikethrough());
        sb.addProp("Framed", this.getFramed());
        sb.addProp("Invert", this.getInvert());
        sb.addProp("Hide", this.getHide());
        return sb.build();
    }

    public static final class Builder
    implements org.eclipse.statet.jcommons.lang.Builder<StyleData> {
        private @Nullable ColorDef foregroundColor;
        private @Nullable ColorDef backgroundColor;
        private int flags;
        private final @Nullable StyleData baseData;

        public Builder(@Nullable StyleData baseData) {
            if (baseData != null) {
                this.flags = baseData.flags;
                this.foregroundColor = baseData.foregroundColor;
                this.backgroundColor = baseData.backgroundColor;
            }
            this.baseData = baseData;
        }

        public void reset() {
            this.flags = 0;
            this.foregroundColor = null;
            this.backgroundColor = null;
        }

        public boolean isEmpty() {
            return this.flags == 0 && this.foregroundColor == null && this.backgroundColor == null;
        }

        public @Nullable ColorDef getForegroundColor() {
            return this.foregroundColor;
        }

        public void setForegroundColor(@Nullable ColorDef foregroundColor) {
            this.foregroundColor = foregroundColor;
        }

        public @Nullable ColorDef getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundColor(@Nullable ColorDef backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public boolean getBold() {
            return (this.flags & 1) != 0;
        }

        public void setBold(boolean enabled) {
            this.flags = enabled ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        }

        public boolean getItalic() {
            return (this.flags & 2) != 0;
        }

        public void setItalic(boolean enabled) {
            this.flags = enabled ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        }

        public byte getUnderline() {
            return (byte)(this.flags >>> 2 & 3);
        }

        public void setUnderline(byte type) {
            this.flags = this.flags & 0xFFFFFFF3 | type << 2;
        }

        public boolean getStrikethrough() {
            return (this.flags & 0x10) != 0;
        }

        public void setStrikethrough(boolean enabled) {
            this.flags = enabled ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
        }

        public boolean getFramed() {
            return (this.flags & 0x20) != 0;
        }

        public void setFramed(boolean enabled) {
            this.flags = enabled ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
        }

        public boolean getInvert() {
            return (this.flags & 0x200) != 0;
        }

        public void setInvert(boolean enabled) {
            this.flags = enabled ? this.flags | 0x200 : this.flags & 0xFFFFFDFF;
        }

        public boolean getHide() {
            return (this.flags & 0x400) != 0;
        }

        public void setHide(boolean enabled) {
            this.flags = enabled ? this.flags | 0x400 : this.flags & 0xFFFFFBFF;
        }

        public StyleData build() {
            StyleData baseData = this.baseData;
            return baseData != null && this.flags == baseData.flags && this.foregroundColor == baseData.foregroundColor && this.backgroundColor == baseData.backgroundColor ? baseData : new StyleData(this.flags, this.foregroundColor, this.backgroundColor);
        }
    }
}

