/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.ui.mode;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.edit.EditUtils;
import org.eclipse.statet.ecommons.waltable.ui.NatEventData;
import org.eclipse.statet.ecommons.waltable.ui.action.DragModeEventHandler;
import org.eclipse.statet.ecommons.waltable.ui.action.IDragMode;
import org.eclipse.statet.ecommons.waltable.ui.action.IMouseAction;
import org.eclipse.statet.ecommons.waltable.ui.action.IMouseClickAction;
import org.eclipse.statet.ecommons.waltable.ui.mode.AbstractModeEventHandler;
import org.eclipse.statet.ecommons.waltable.ui.mode.ModeSupport;
import org.eclipse.swt.events.MouseEvent;

public class MouseModeEventHandler
extends AbstractModeEventHandler {
    private final NatTable natTable;
    private final MouseEvent initialMouseDownEvent;
    private final IMouseAction singleClickAction;
    private final IMouseAction doubleClickAction;
    private boolean mouseDown;
    private final IDragMode dragMode;
    private boolean doubleClick;

    public MouseModeEventHandler(ModeSupport modeSupport, NatTable natTable, MouseEvent initialMouseDownEvent, IMouseAction singleClickAction, IMouseAction doubleClickAction, IDragMode dragMode) {
        super(modeSupport);
        this.natTable = natTable;
        this.mouseDown = true;
        this.initialMouseDownEvent = initialMouseDownEvent;
        this.singleClickAction = singleClickAction;
        this.doubleClickAction = doubleClickAction;
        this.dragMode = dragMode;
    }

    @Override
    public void mouseUp(final MouseEvent event) {
        this.mouseDown = false;
        this.doubleClick = false;
        if (this.singleClickAction != null) {
            if (EditUtils.commitAndCloseActiveEditor()) {
                if (this.doubleClickAction != null && (this.isActionExclusive(this.singleClickAction) || this.isActionExclusive(this.doubleClickAction))) {
                    event.display.timerExec(event.display.getDoubleClickTime(), new Runnable(){

                        @Override
                        public void run() {
                            if (!MouseModeEventHandler.this.doubleClick) {
                                MouseModeEventHandler.this.executeClickAction(MouseModeEventHandler.this.singleClickAction, event);
                            }
                        }
                    });
                } else {
                    this.executeClickAction(this.singleClickAction, event);
                }
            }
        } else if (this.doubleClickAction == null) {
            this.switchMode("NORMAL_MODE");
        }
    }

    @Override
    public void mouseDoubleClick(MouseEvent event) {
        this.doubleClick = true;
        this.executeClickAction(this.doubleClickAction, event);
    }

    @Override
    public synchronized void mouseMove(MouseEvent event) {
        if (this.mouseDown && this.dragMode != null) {
            if (EditUtils.commitAndCloseActiveEditor()) {
                this.dragMode.mouseDown(this.natTable, this.initialMouseDownEvent);
                this.switchMode(new DragModeEventHandler(this.getModeSupport(), this.natTable, this.dragMode));
            } else {
                this.switchMode("NORMAL_MODE");
            }
        } else {
            this.switchMode("NORMAL_MODE");
        }
    }

    private void executeClickAction(IMouseAction action, MouseEvent event) {
        if (EditUtils.commitAndCloseActiveEditor() && action != null && event != null) {
            event.data = NatEventData.createInstanceFromEvent(event);
            action.run(this.natTable, event);
            this.switchMode("NORMAL_MODE");
        }
    }

    private boolean isActionExclusive(IMouseAction action) {
        if (action instanceof IMouseClickAction) {
            return ((IMouseClickAction)action).isExclusive();
        }
        return false;
    }
}

