/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit.editor;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Direction;
import org.eclipse.statet.ecommons.waltable.core.style.BasicStyle;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.core.style.Style;
import org.eclipse.statet.ecommons.waltable.data.convert.ConversionFailedException;
import org.eclipse.statet.ecommons.waltable.data.validate.ValidationFailedException;
import org.eclipse.statet.ecommons.waltable.edit.EditConfigAttributes;
import org.eclipse.statet.ecommons.waltable.edit.EditMode;
import org.eclipse.statet.ecommons.waltable.edit.editor.AbstractCellEditor;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TableCellEditor
extends AbstractCellEditor {
    private TableViewer viewer;
    private final boolean moveSelectionOnEnter;
    private final boolean alwaysOpenEditor;
    private int fixedSubCellHeight;
    private final FocusListener focusListener = new InternalFocusListener();
    private InternalLabelProvider labelProvider;
    protected ICellEditorValidator cellEditorValidator = new ICellEditorValidator(){

        public String isValid(Object value) {
            if (TableCellEditor.this.displayConverter != null) {
                Object cValue = null;
                try {
                    cValue = TableCellEditor.this.displayConverter.displayToCanonicalValue(TableCellEditor.this.layerCell, TableCellEditor.this.configRegistry, value);
                    if (!TableCellEditor.this.validateCanonicalValue(cValue)) {
                        return Messages.getString("AbstractCellEditor.validationFailure");
                    }
                }
                catch (ConversionFailedException | ValidationFailedException e) {
                    return e.getLocalizedMessage();
                }
            }
            return null;
        }
    };

    public TableCellEditor() {
        this(20, true, true);
    }

    public TableCellEditor(int fixedSubCellHeight, boolean moveSelectionOnEnter, boolean alwaysOpenEditor) {
        this.setFixedSubCellHeight(fixedSubCellHeight);
        this.moveSelectionOnEnter = moveSelectionOnEnter;
        this.alwaysOpenEditor = alwaysOpenEditor;
    }

    @Override
    public Object getEditorValue() {
        return this.viewer.getInput();
    }

    @Override
    public void setEditorValue(Object value) {
        if (value != null && value.getClass().isArray()) {
            this.viewer.setInput(value);
        }
    }

    @Override
    public Object getCanonicalValue() {
        Object[] editorValues = this.getDataAsArray(this.getEditorValue());
        Object[] dataValues = new Object[editorValues.length];
        int i = 0;
        while (i < editorValues.length) {
            Object value = editorValues[i];
            Object canonicalValue = this.displayConverter != null ? this.displayConverter.displayToCanonicalValue(this.layerCell, this.configRegistry, value) : value;
            dataValues[i] = canonicalValue;
            ++i;
        }
        if (this.layerCell.getDataValue(0, null).getClass().isArray()) {
            Object[] cellDataArray = (Object[])this.layerCell.getDataValue(0, null);
            int i2 = 0;
            while (i2 < cellDataArray.length) {
                cellDataArray[i2] = dataValues[i2];
                ++i2;
            }
        } else if (this.layerCell.getDataValue(0, null) instanceof Collection) {
            Collection cellDataCollection = (Collection)this.layerCell.getDataValue(0, null);
            cellDataCollection.clear();
            cellDataCollection.addAll(Arrays.asList(dataValues));
        }
        return this.layerCell.getDataValue(0, null);
    }

    @Override
    public void setCanonicalValue(Object canonicalValue) {
        Object[] values = this.getDataAsArray(canonicalValue);
        if (values != null) {
            ValueWrapper[] editorValues = new ValueWrapper[values.length];
            int i = 0;
            while (i < values.length) {
                Object value = values[i];
                Object displayValue = this.displayConverter != null ? this.displayConverter.canonicalToDisplayValue(this.layerCell, this.configRegistry, value) : value;
                editorValues[i] = new ValueWrapper(String.valueOf(displayValue));
                ++i;
            }
            this.setEditorValue(editorValues);
        }
    }

    public Table getEditorControl() {
        return this.viewer.getTable();
    }

    public Table createEditorControl(Composite parent) {
        this.viewer = new TableViewer(parent, 65536);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn emptyColumn = new TableViewerColumn(this.viewer, 0);
        emptyColumn.getColumn().setWidth(0);
        emptyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }
        });
        TableViewerColumn singleColumn = new TableViewerColumn(this.viewer, 0);
        singleColumn.getColumn().setAlignment(CellStyleUtil.getHorizontalAlignmentSWT(this.cellStyle, 16384));
        singleColumn.setLabelProvider((CellLabelProvider)this.labelProvider);
        singleColumn.setEditingSupport(this.getEditingSupport());
        final Table tableControl = this.viewer.getTable();
        tableControl.setBackground(this.cellStyle.getAttributeValue(CellStyling.BACKGROUND_COLOR));
        tableControl.setLinesVisible(true);
        tableControl.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = TableCellEditor.this.fixedSubCellHeight + 1;
            }
        });
        tableControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 27 && event.stateMask == 0) {
                    TableCellEditor.this.close();
                }
                if (event.keyCode == 0x100000B) {
                    Object element = ((StructuredSelection)TableCellEditor.this.viewer.getSelection()).getFirstElement();
                    if (element == null) {
                        tableControl.setSelection(tableControl.getTopIndex());
                        element = ((StructuredSelection)TableCellEditor.this.viewer.getSelection()).getFirstElement();
                    }
                    if (element != null) {
                        TableCellEditor.this.viewer.editElement(element, 1);
                    }
                }
            }
        });
        tableControl.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                tableControl.getColumn(1).setWidth(tableControl.getClientArea().width);
                Point mouseLoc = Display.getCurrent().getCursorLocation();
                Point tablePos = tableControl.toDisplay(0, 0);
                int relativeX = mouseLoc.x - tablePos.x;
                int relativeY = mouseLoc.y - tablePos.y;
                TableItem item = tableControl.getItem(new Point(relativeX, relativeY));
                if (item != null) {
                    tableControl.setSelection(item);
                } else {
                    tableControl.setSelection(tableControl.getTopIndex());
                }
                if (tableControl.getItemCount() > 0) {
                    TableCellEditor.this.viewer.editElement(((StructuredSelection)TableCellEditor.this.viewer.getSelection()).getFirstElement(), 1);
                }
            }
        });
        return tableControl;
    }

    @Override
    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        this.labelProvider = new InternalLabelProvider();
        this.createEditorControl(parent);
        this.setCanonicalValue(originalCanonicalValue);
        this.getEditorControl().forceFocus();
        return this.getEditorControl();
    }

    @Override
    public void close() {
        if (!this.viewer.isCellEditorActive()) {
            super.close();
        }
    }

    protected Object[] getDataAsArray(Object cellData) {
        Object[] cellDataArray = null;
        if (cellData.getClass().isArray()) {
            cellDataArray = (Object[])cellData;
        } else if (cellData instanceof Collection) {
            Collection cellDataCollection = (Collection)cellData;
            cellDataArray = cellDataCollection.toArray();
        }
        return cellDataArray;
    }

    public int getFixedSubCellHeight() {
        return this.fixedSubCellHeight;
    }

    public void setFixedSubCellHeight(int fixedSubCellHeight) {
        this.fixedSubCellHeight = fixedSubCellHeight;
    }

    protected EditingSupport getEditingSupport() {
        return new TableCellEditingSupport();
    }

    @Override
    public void addEditorControlListeners() {
        Table editorControl = this.getEditorControl();
        if (editorControl != null && !editorControl.isDisposed() && this.editMode == EditMode.INLINE) {
            editorControl.addTraverseListener(this.traverseListener);
            editorControl.addFocusListener(this.focusListener);
        }
    }

    @Override
    public void removeEditorControlListeners() {
        Table editorControl = this.getEditorControl();
        if (editorControl != null && !editorControl.isDisposed()) {
            editorControl.removeTraverseListener(this.traverseListener);
            editorControl.removeFocusListener(this.focusListener);
        }
    }

    protected class InternalFocusListener
    implements FocusListener {
        boolean hasFocus = false;

        protected InternalFocusListener() {
        }

        public void focusLost(final FocusEvent e) {
            this.hasFocus = false;
            Display.getCurrent().timerExec(100, new Runnable(){

                @Override
                public void run() {
                    if (!InternalFocusListener.this.hasFocus && !TableCellEditor.this.commit(null, true) && e.widget instanceof Control && !e.widget.isDisposed()) {
                        ((Control)e.widget).forceFocus();
                    }
                }
            });
        }

        public void focusGained(FocusEvent e) {
            this.hasFocus = true;
        }
    }

    protected class InternalLabelProvider
    extends ColumnLabelProvider {
        private final Style normalStyle;
        private Style conversionErrorStyle;
        private Style validationErrorStyle;

        public InternalLabelProvider() {
            this.normalStyle = TableCellEditor.this.cellStyle;
            this.conversionErrorStyle = TableCellEditor.this.configRegistry.getAttribute(EditConfigAttributes.CONVERSION_ERROR_STYLE, DisplayMode.EDIT, TableCellEditor.this.labelStack.getLabels());
            if (this.conversionErrorStyle == null) {
                this.conversionErrorStyle = new BasicStyle();
                this.conversionErrorStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, GUIHelper.COLOR_RED);
            }
            this.validationErrorStyle = TableCellEditor.this.configRegistry.getAttribute(EditConfigAttributes.VALIDATION_ERROR_STYLE, DisplayMode.EDIT, TableCellEditor.this.labelStack.getLabels());
            if (this.validationErrorStyle == null) {
                this.validationErrorStyle = new BasicStyle();
                this.validationErrorStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, GUIHelper.COLOR_RED);
            }
        }

        public Style getActiveCellStyle(Object element) {
            if (!((ValueWrapper)element).isValid()) {
                return this.validationErrorStyle;
            }
            return this.normalStyle;
        }

        public void applyCellStyle(Control editorControl, Object element) {
            Font font;
            Color background;
            Color foreground = this.getForeground(element);
            if (foreground != null) {
                editorControl.setForeground(foreground);
            }
            if ((background = this.getBackground(element)) != null) {
                editorControl.setBackground(this.getBackground(element));
            }
            if ((font = this.getFont(element)) != null) {
                editorControl.setFont(font);
            }
        }

        public Color getForeground(Object element) {
            return this.getActiveCellStyle(element).getAttributeValue(CellStyling.FOREGROUND_COLOR);
        }

        public Color getBackground(Object element) {
            return this.getActiveCellStyle(element).getAttributeValue(CellStyling.BACKGROUND_COLOR);
        }

        public Font getFont(Object element) {
            return this.getActiveCellStyle(element).getAttributeValue(CellStyling.FONT);
        }
    }

    protected class TableCellEditingSupport
    extends EditingSupport {
        private CellEditor editor;

        public TableCellEditingSupport() {
            super((ColumnViewer)TableCellEditor.this.viewer);
            this.editor = new TextCellEditor((Composite)TableCellEditor.this.viewer.getTable());
        }

        protected CellEditor getCellEditor(final Object element) {
            this.editor = new TextCellEditor((Composite)TableCellEditor.this.viewer.getTable());
            this.editor.setValidator(TableCellEditor.this.cellEditorValidator);
            this.editor.addListener(new ICellEditorListener(){

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    ((ValueWrapper)element).setValid(TableCellEditingSupport.this.editor.isValueValid());
                    ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.labelProvider.applyCellStyle(TableCellEditingSupport.this.editor.getControl(), element);
                }

                public void cancelEditor() {
                    TableCellEditor.this.close();
                }

                public void applyEditorValue() {
                }
            });
            this.editor.getControl().addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent event) {
                    if (event.keyCode == 9) {
                        TableCellEditingSupport.this.setValue(element, ((Text)TableCellEditingSupport.this.editor.getControl()).getText());
                        boolean committed = false;
                        if (event.stateMask == 131072) {
                            committed = TableCellEditor.this.commit(Direction.LEFT);
                        } else if (event.stateMask == 0) {
                            committed = TableCellEditor.this.commit(Direction.RIGHT);
                        }
                        if (!committed) {
                            event.doit = false;
                        }
                    }
                }
            });
            this.editor.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                        TableCellEditingSupport.this.setValue(element, ((Text)TableCellEditingSupport.this.editor.getControl()).getText());
                        if (TableCellEditingSupport.this.editor.isValueValid()) {
                            int selectionIndex = ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().getSelectionIndex();
                            if (((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.moveSelectionOnEnter && selectionIndex + 1 < ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().getItemCount()) {
                                ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().setSelection(++selectionIndex);
                                if (((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.alwaysOpenEditor) {
                                    ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.editElement(((StructuredSelection)((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getSelection()).getFirstElement(), 1);
                                }
                            } else {
                                TableCellEditor.this.commit(null);
                            }
                        } else {
                            ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.editElement(((StructuredSelection)((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getSelection()).getFirstElement(), 1);
                        }
                    } else if (event.keyCode == 0x1000002) {
                        TableCellEditingSupport.this.setValue(element, ((Text)TableCellEditingSupport.this.editor.getControl()).getText());
                        int selectionIndex = ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().getSelectionIndex();
                        if (selectionIndex + 1 < ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().getItemCount()) {
                            ++selectionIndex;
                        }
                        ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().setSelection(selectionIndex);
                        if (((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.alwaysOpenEditor) {
                            ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.editElement(((StructuredSelection)((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getSelection()).getFirstElement(), 1);
                        }
                    } else if (event.keyCode == 0x1000001) {
                        TableCellEditingSupport.this.setValue(element, ((Text)TableCellEditingSupport.this.editor.getControl()).getText());
                        int selectionIndex = ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().getSelectionIndex();
                        if (selectionIndex > 0) {
                            --selectionIndex;
                        }
                        ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getTable().setSelection(selectionIndex);
                        if (((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.alwaysOpenEditor) {
                            ((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.editElement(((StructuredSelection)((TableCellEditingSupport)TableCellEditingSupport.this).TableCellEditor.this.viewer.getSelection()).getFirstElement(), 1);
                        }
                    }
                }
            });
            this.editor.getControl().addFocusListener(TableCellEditor.this.focusListener);
            TableCellEditor.this.labelProvider.applyCellStyle(this.editor.getControl(), element);
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((ValueWrapper)element).getValue();
        }

        protected void setValue(Object element, Object value) {
            if (this.editor.isValueValid()) {
                ((ValueWrapper)element).setValue(value);
                ((ValueWrapper)element).setValid(true);
            } else {
                ((ValueWrapper)element).setValid(false);
            }
            TableCellEditor.this.viewer.refresh();
        }
    }

    protected class ValueWrapper {
        private Object value;
        private boolean valid = true;

        protected ValueWrapper(Object value) {
            this.setValue(value);
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
            this.valid = TableCellEditor.this.cellEditorValidator.isValid(value) == null;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public String toString() {
            return this.value != null ? this.value.toString() : "";
        }
    }
}

